/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.scanners.AbstractScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.Utils;

public class MemberUsageScanner
extends AbstractScanner {
    private ClassPool classPool;

    @Override
    public void scan(Object object, Store store) {
        try {
            CtClass ctClass = this.getClassPool().get(this.getMetadataAdapter().getClassName(object));
            for (CtConstructor ctBehavior : ctClass.getDeclaredConstructors()) {
                this.scanMember(ctBehavior, store);
            }
            for (CtBehavior ctBehavior : ctClass.getDeclaredMethods()) {
                this.scanMember(ctBehavior, store);
            }
            ctClass.detach();
        }
        catch (Exception exception) {
            throw new ReflectionsException("Could not scan method usage for " + this.getMetadataAdapter().getClassName(object), exception);
        }
    }

    void scanMember(CtBehavior ctBehavior, final Store store) {
        final String string = ctBehavior.getDeclaringClass().getName() + "." + ctBehavior.getMethodInfo().getName() + "(" + this.parameterNames(ctBehavior.getMethodInfo()) + ")";
        ctBehavior.instrument(new ExprEditor(){

            @Override
            public void edit(NewExpr newExpr) {
                try {
                    MemberUsageScanner.this.put(store, newExpr.getConstructor().getDeclaringClass().getName() + ".<init>(" + MemberUsageScanner.this.parameterNames(newExpr.getConstructor().getMethodInfo()) + ")", newExpr.getLineNumber(), string);
                }
                catch (NotFoundException notFoundException) {
                    throw new ReflectionsException("Could not find new instance usage in " + string, notFoundException);
                }
            }

            @Override
            public void edit(MethodCall methodCall) {
                try {
                    MemberUsageScanner.this.put(store, methodCall.getMethod().getDeclaringClass().getName() + "." + methodCall.getMethodName() + "(" + MemberUsageScanner.this.parameterNames(methodCall.getMethod().getMethodInfo()) + ")", methodCall.getLineNumber(), string);
                }
                catch (NotFoundException notFoundException) {
                    throw new ReflectionsException("Could not find member " + methodCall.getClassName() + " in " + string, notFoundException);
                }
            }

            @Override
            public void edit(ConstructorCall constructorCall) {
                try {
                    MemberUsageScanner.this.put(store, constructorCall.getConstructor().getDeclaringClass().getName() + ".<init>(" + MemberUsageScanner.this.parameterNames(constructorCall.getConstructor().getMethodInfo()) + ")", constructorCall.getLineNumber(), string);
                }
                catch (NotFoundException notFoundException) {
                    throw new ReflectionsException("Could not find member " + constructorCall.getClassName() + " in " + string, notFoundException);
                }
            }

            @Override
            public void edit(FieldAccess fieldAccess) {
                try {
                    MemberUsageScanner.this.put(store, fieldAccess.getField().getDeclaringClass().getName() + "." + fieldAccess.getFieldName(), fieldAccess.getLineNumber(), string);
                }
                catch (NotFoundException notFoundException) {
                    throw new ReflectionsException("Could not find member " + fieldAccess.getFieldName() + " in " + string, notFoundException);
                }
            }
        });
    }

    private void put(Store store, String string, int n, String string2) {
        if (this.acceptResult(string)) {
            this.put(store, string, string2 + " #" + n);
        }
    }

    String parameterNames(MethodInfo methodInfo) {
        return Utils.join(this.getMetadataAdapter().getParameterNames(methodInfo), ", ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getClassPool() {
        if (this.classPool == null) {
            MemberUsageScanner memberUsageScanner = this;
            synchronized (memberUsageScanner) {
                this.classPool = new ClassPool();
                ClassLoader[] classLoaderArray = this.getConfiguration().getClassLoaders();
                if (classLoaderArray == null) {
                    classLoaderArray = ClasspathHelper.classLoaders(new ClassLoader[0]);
                }
                for (ClassLoader classLoader : classLoaderArray) {
                    this.classPool.appendClassPath(new LoaderClassPath(classLoader));
                }
            }
        }
        return this.classPool;
    }
}

