/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.serializers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.util.Utils;

public class JavaCodeSerializer
implements Serializer {
    private static final String pathSeparator = "_";
    private static final String doubleSeparator = "__";
    private static final String dotSeparator = ".";
    private static final String arrayDescriptor = "$$";
    private static final String tokenSeparator = "_";

    @Override
    public Reflections read(InputStream inputStream) {
        throw new UnsupportedOperationException("read is not implemented on JavaCodeSerializer");
    }

    @Override
    public File save(Reflections reflections, String string) {
        String string2;
        String string3;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        String string4 = string.replace('.', '/').concat(".java");
        File file = Utils.prepareFile(string4);
        int n = string.lastIndexOf(46);
        if (n == -1) {
            string3 = "";
            string2 = string.substring(string.lastIndexOf(47) + 1);
        } else {
            string3 = string.substring(string.lastIndexOf(47) + 1, n);
            string2 = string.substring(n + 1);
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("//generated using Reflections JavaCodeSerializer").append(" [").append(new Date()).append("]").append("\n");
            if (string3.length() != 0) {
                stringBuilder.append("package ").append(string3).append(";\n");
                stringBuilder.append("\n");
            }
            stringBuilder.append("public interface ").append(string2).append(" {\n\n");
            stringBuilder.append(this.toString(reflections));
            stringBuilder.append("}\n");
            Files.write(new File(string4).toPath(), stringBuilder.toString().getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        return file;
    }

    @Override
    public String toString(Reflections reflections) {
        if (reflections.getStore().keys(Utils.index(TypeElementsScanner.class)).isEmpty() && Reflections.log != null) {
            Reflections.log.warn("JavaCodeSerializer needs TypeElementsScanner configured");
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<Object> list = new ArrayList();
        int n = 1;
        ArrayList<String> arrayList = new ArrayList<String>(reflections.getStore().keys(Utils.index(TypeElementsScanner.class)));
        Collections.sort(arrayList);
        for (String string : arrayList) {
            int n2;
            int n3;
            List<String> list2 = Arrays.asList(string.split("\\."));
            for (n3 = 0; n3 < Math.min(list2.size(), list.size()) && list2.get(n3).equals(list.get(n3)); ++n3) {
            }
            for (n2 = list.size(); n2 > n3; --n2) {
                stringBuilder.append(Utils.repeat("\t", --n)).append("}\n");
            }
            for (n2 = n3; n2 < list2.size() - 1; ++n2) {
                stringBuilder.append(Utils.repeat("\t", n++)).append("public interface ").append(this.getNonDuplicateName(list2.get(n2), list2, n2)).append(" {\n");
            }
            String string2 = list2.get(list2.size() - 1);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            Set<String> set = reflections.getStore().get(Utils.index(TypeElementsScanner.class), string);
            List list3 = StreamSupport.stream(set.spliterator(), false).sorted().collect(Collectors.toList());
            for (String string3 : list3) {
                if (string3.startsWith("@")) {
                    arrayList2.add(string3.substring(1));
                    continue;
                }
                if (string3.contains("(")) {
                    if (string3.startsWith("<")) continue;
                    int n4 = string3.indexOf(40);
                    String string4 = string3.substring(0, n4);
                    String string5 = string3.substring(n4 + 1, string3.indexOf(")"));
                    String string6 = "";
                    if (string5.length() != 0) {
                        string6 = "_" + string5.replace(dotSeparator, "_").replace(", ", doubleSeparator).replace("[]", arrayDescriptor);
                    }
                    String string7 = string4 + string6;
                    if (!arrayList4.contains(string4)) {
                        arrayList4.add(string4);
                        continue;
                    }
                    arrayList4.add(string7);
                    continue;
                }
                if (Utils.isEmpty(string3)) continue;
                arrayList3.add(string3);
            }
            stringBuilder.append(Utils.repeat("\t", n++)).append("public interface ").append(this.getNonDuplicateName(string2, list2, list2.size() - 1)).append(" {\n");
            if (!arrayList3.isEmpty()) {
                stringBuilder.append(Utils.repeat("\t", n++)).append("public interface fields {\n");
                for (String string3 : arrayList3) {
                    stringBuilder.append(Utils.repeat("\t", n)).append("public interface ").append(this.getNonDuplicateName(string3, list2)).append(" {}\n");
                }
                stringBuilder.append(Utils.repeat("\t", --n)).append("}\n");
            }
            if (!arrayList4.isEmpty()) {
                stringBuilder.append(Utils.repeat("\t", n++)).append("public interface methods {\n");
                for (String string3 : arrayList4) {
                    String string8 = this.getNonDuplicateName(string3, arrayList3);
                    stringBuilder.append(Utils.repeat("\t", n)).append("public interface ").append(this.getNonDuplicateName(string8, list2)).append(" {}\n");
                }
                stringBuilder.append(Utils.repeat("\t", --n)).append("}\n");
            }
            if (!arrayList2.isEmpty()) {
                stringBuilder.append(Utils.repeat("\t", n++)).append("public interface annotations {\n");
                Iterator<Object> iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    String string9 = string3 = (String)iterator.next();
                    string9 = this.getNonDuplicateName(string9, list2);
                    stringBuilder.append(Utils.repeat("\t", n)).append("public interface ").append(string9).append(" {}\n");
                }
                stringBuilder.append(Utils.repeat("\t", --n)).append("}\n");
            }
            list = list2;
        }
        for (int i = list.size(); i >= 1; --i) {
            stringBuilder.append(Utils.repeat("\t", i)).append("}\n");
        }
        return stringBuilder.toString();
    }

    private String getNonDuplicateName(String string, List<String> list, int n) {
        String string2 = this.normalize(string);
        for (int i = 0; i < n; ++i) {
            if (!string2.equals(list.get(i))) continue;
            return this.getNonDuplicateName(string2 + "_", list, n);
        }
        return string2;
    }

    private String normalize(String string) {
        return string.replace(dotSeparator, "_");
    }

    private String getNonDuplicateName(String string, List<String> list) {
        return this.getNonDuplicateName(string, list, list.size());
    }

    public static Class<?> resolveClassOf(Class clazz) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getDeclaringClass()) {
            linkedList.addFirst(clazz2.getSimpleName());
        }
        String string = Utils.join(linkedList.subList(1, linkedList.size()), dotSeparator).replace(".$", "$");
        return Class.forName(string);
    }

    public static Class<?> resolveClass(Class clazz) {
        try {
            return JavaCodeSerializer.resolveClassOf(clazz);
        }
        catch (Exception exception) {
            throw new ReflectionsException("could not resolve to class " + clazz.getName(), exception);
        }
    }

    public static Field resolveField(Class clazz) {
        try {
            String string = clazz.getSimpleName();
            Class<?> clazz2 = clazz.getDeclaringClass().getDeclaringClass();
            return JavaCodeSerializer.resolveClassOf(clazz2).getDeclaredField(string);
        }
        catch (Exception exception) {
            throw new ReflectionsException("could not resolve to field " + clazz.getName(), exception);
        }
    }

    public static Annotation resolveAnnotation(Class clazz) {
        try {
            String string = clazz.getSimpleName().replace("_", dotSeparator);
            Class<?> clazz2 = clazz.getDeclaringClass().getDeclaringClass();
            Class<?> clazz3 = JavaCodeSerializer.resolveClassOf(clazz2);
            Class<?> clazz4 = ReflectionUtils.forName(string, new ClassLoader[0]);
            Object obj = clazz3.getAnnotation(clazz4);
            return obj;
        }
        catch (Exception exception) {
            throw new ReflectionsException("could not resolve to annotation " + clazz.getName(), exception);
        }
    }

    public static Method resolveMethod(Class clazz) {
        String string = clazz.getSimpleName();
        try {
            Class[] classArray;
            String[] stringArray;
            String string2;
            if (string.contains("_")) {
                string2 = string.substring(0, string.indexOf("_"));
                stringArray = string.substring(string.indexOf("_") + 1).split(doubleSeparator);
                classArray = new Class[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].replace(arrayDescriptor, "[]").replace("_", dotSeparator);
                    classArray[i] = ReflectionUtils.forName(string3, new ClassLoader[0]);
                }
            } else {
                string2 = string;
                classArray = null;
            }
            stringArray = clazz.getDeclaringClass().getDeclaringClass();
            return JavaCodeSerializer.resolveClassOf(stringArray).getDeclaredMethod(string2, classArray);
        }
        catch (Exception exception) {
            throw new ReflectionsException("could not resolve to method " + clazz.getName(), exception);
        }
    }
}

