/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.serializers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.serializers.Serializer;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.Utils;

public class XmlSerializer
implements Serializer {
    @Override
    public Reflections read(InputStream inputStream) {
        Reflections reflections;
        Document document;
        try {
            document = Reflections.class.getDeclaredConstructor(new Class[0]);
            document.setAccessible(true);
            reflections = (Reflections)document.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            reflections = new Reflections(new ConfigurationBuilder());
        }
        try {
            document = new SAXReader().read(inputStream);
            for (Object e : document.getRootElement().elements()) {
                Element element = (Element)e;
                for (Object e2 : element.elements()) {
                    Element element2 = (Element)e2;
                    Element element3 = element2.element("key");
                    Element element4 = element2.element("values");
                    for (Object e3 : element4.elements()) {
                        Element element5 = (Element)e3;
                        reflections.getStore().put(element.getName(), element3.getText(), element5.getText());
                    }
                }
            }
        }
        catch (DocumentException documentException) {
            throw new ReflectionsException("could not read.", documentException);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not read. Make sure relevant dependencies exist on classpath.", throwable);
        }
        return reflections;
    }

    @Override
    public File save(Reflections reflections, String string) {
        File file = Utils.prepareFile(string);
        try {
            Document document = this.createDocument(reflections);
            XMLWriter xMLWriter = new XMLWriter((OutputStream)new FileOutputStream(file), OutputFormat.createPrettyPrint());
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (IOException iOException) {
            throw new ReflectionsException("could not save to file " + string, iOException);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not save to file " + string + ". Make sure relevant dependencies exist on classpath.", throwable);
        }
        return file;
    }

    @Override
    public String toString(Reflections reflections) {
        Document document = this.createDocument(reflections);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
            xMLWriter.write(document);
            xMLWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    private Document createDocument(Reflections reflections) {
        Store store = reflections.getStore();
        Document document = DocumentFactory.getInstance().createDocument();
        Element element = document.addElement("Reflections");
        for (String string : store.keySet()) {
            Element element2 = element.addElement(string);
            for (String string2 : store.keys(string)) {
                Element element3 = element2.addElement("entry");
                element3.addElement("key").setText(string2);
                Element element4 = element3.addElement("values");
                for (String string3 : store.get(string, string2)) {
                    element4.addElement("value").setText(string3);
                }
            }
        }
        return document;
    }
}

