/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.reflections.Reflections;

public abstract class ClasspathHelper {
    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader staticClassLoader() {
        return Reflections.class.getClassLoader();
    }

    public static ClassLoader[] classLoaders(ClassLoader ... classLoaderArray) {
        ClassLoader[] classLoaderArray2;
        if (classLoaderArray != null && classLoaderArray.length != 0) {
            return classLoaderArray;
        }
        ClassLoader classLoader = ClasspathHelper.contextClassLoader();
        ClassLoader classLoader2 = ClasspathHelper.staticClassLoader();
        if (classLoader != null) {
            if (classLoader2 != null && classLoader != classLoader2) {
                ClassLoader[] classLoaderArray3 = new ClassLoader[2];
                classLoaderArray3[0] = classLoader;
                classLoaderArray2 = classLoaderArray3;
                classLoaderArray3[1] = classLoader2;
            } else {
                ClassLoader[] classLoaderArray4 = new ClassLoader[1];
                classLoaderArray2 = classLoaderArray4;
                classLoaderArray4[0] = classLoader;
            }
        } else {
            classLoaderArray2 = new ClassLoader[]{};
        }
        return classLoaderArray2;
    }

    public static Collection<URL> forPackage(String string, ClassLoader ... classLoaderArray) {
        return ClasspathHelper.forResource(ClasspathHelper.resourceName(string), classLoaderArray);
    }

    public static Collection<URL> forResource(String string, ClassLoader ... classLoaderArray) {
        ClassLoader[] classLoaderArray2;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (ClassLoader classLoader : classLoaderArray2 = ClasspathHelper.classLoaders(classLoaderArray)) {
            try {
                Enumeration<URL> enumeration = classLoader.getResources(string);
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    int n = uRL.toExternalForm().lastIndexOf(string);
                    if (n != -1) {
                        arrayList.add(new URL(uRL, uRL.toExternalForm().substring(0, n)));
                        continue;
                    }
                    arrayList.add(uRL);
                }
            }
            catch (IOException iOException) {
                if (Reflections.log == null) continue;
                Reflections.log.error("error getting resources for " + string, (Throwable)iOException);
            }
        }
        return ClasspathHelper.distinctUrls(arrayList);
    }

    public static URL forClass(Class<?> clazz, ClassLoader ... classLoaderArray) {
        ClassLoader[] classLoaderArray2 = ClasspathHelper.classLoaders(classLoaderArray);
        String string = clazz.getName().replace(".", "/") + ".class";
        for (ClassLoader classLoader : classLoaderArray2) {
            try {
                URL uRL = classLoader.getResource(string);
                if (uRL == null) continue;
                String string2 = uRL.toExternalForm().substring(0, uRL.toExternalForm().lastIndexOf(clazz.getPackage().getName().replace(".", "/")));
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (Reflections.log == null) continue;
                Reflections.log.warn("Could not get URL", (Throwable)malformedURLException);
            }
        }
        return null;
    }

    public static Collection<URL> forClassLoader() {
        return ClasspathHelper.forClassLoader(ClasspathHelper.classLoaders(new ClassLoader[0]));
    }

    public static Collection<URL> forClassLoader(ClassLoader ... classLoaderArray) {
        ClassLoader[] classLoaderArray2;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ClassLoader[] classLoaderArray3 = classLoaderArray2 = ClasspathHelper.classLoaders(classLoaderArray);
        int n = classLoaderArray3.length;
        for (int i = 0; i < n; ++i) {
            for (ClassLoader classLoader = classLoaderArray3[i]; classLoader != null; classLoader = classLoader.getParent()) {
                URL[] uRLArray;
                if (!(classLoader instanceof URLClassLoader) || (uRLArray = ((URLClassLoader)classLoader).getURLs()) == null) continue;
                arrayList.addAll(Arrays.asList(uRLArray));
            }
        }
        return ClasspathHelper.distinctUrls(arrayList);
    }

    public static Collection<URL> forJavaClassPath() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String string = System.getProperty("java.class.path");
        if (string != null) {
            for (String string2 : string.split(File.pathSeparator)) {
                try {
                    arrayList.add(new File(string2).toURI().toURL());
                }
                catch (Exception exception) {
                    if (Reflections.log == null) continue;
                    Reflections.log.warn("Could not get URL", (Throwable)exception);
                }
            }
        }
        return ClasspathHelper.distinctUrls(arrayList);
    }

    public static Collection<URL> forWebInfLib(ServletContext servletContext) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Set set = servletContext.getResourcePaths("/WEB-INF/lib");
        if (set == null) {
            return arrayList;
        }
        for (Object e : set) {
            try {
                arrayList.add(servletContext.getResource((String)e));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return ClasspathHelper.distinctUrls(arrayList);
    }

    public static URL forWebInfClasses(ServletContext servletContext) {
        block4: {
            try {
                String string = servletContext.getRealPath("/WEB-INF/classes");
                if (string != null) {
                    File file = new File(string);
                    if (file.exists()) {
                        return file.toURL();
                    }
                    break block4;
                }
                return servletContext.getResource("/WEB-INF/classes");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Collection<URL> forManifest() {
        return ClasspathHelper.forManifest(ClasspathHelper.forClassLoader());
    }

    public static Collection<URL> forManifest(URL uRL) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(uRL);
        try {
            String string;
            Manifest manifest;
            String string2 = ClasspathHelper.cleanPath(uRL);
            File file = new File(string2);
            JarFile jarFile = new JarFile(string2);
            URL uRL2 = ClasspathHelper.tryToGetValidUrl(file.getPath(), new File(string2).getParent(), string2);
            if (uRL2 != null) {
                arrayList.add(uRL2);
            }
            if ((manifest = jarFile.getManifest()) != null && (string = manifest.getMainAttributes().getValue(new Attributes.Name("Class-Path"))) != null) {
                for (String string3 : string.split(" ")) {
                    uRL2 = ClasspathHelper.tryToGetValidUrl(file.getPath(), new File(string2).getParent(), string3);
                    if (uRL2 == null) continue;
                    arrayList.add(uRL2);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ClasspathHelper.distinctUrls(arrayList);
    }

    public static Collection<URL> forManifest(Iterable<URL> iterable) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : iterable) {
            arrayList.addAll(ClasspathHelper.forManifest(uRL));
        }
        return ClasspathHelper.distinctUrls(arrayList);
    }

    static URL tryToGetValidUrl(String string, String string2, String string3) {
        try {
            if (new File(string3).exists()) {
                return new File(string3).toURI().toURL();
            }
            if (new File(string2 + File.separator + string3).exists()) {
                return new File(string2 + File.separator + string3).toURI().toURL();
            }
            if (new File(string + File.separator + string3).exists()) {
                return new File(string + File.separator + string3).toURI().toURL();
            }
            if (new File(new URL(string3).getFile()).exists()) {
                return new File(new URL(string3).getFile()).toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static String cleanPath(URL uRL) {
        String string = uRL.getPath();
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (string.startsWith("jar:")) {
            string = string.substring("jar:".length());
        }
        if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        if (string.endsWith("!/")) {
            string = string.substring(0, string.lastIndexOf("!/")) + "/";
        }
        return string;
    }

    private static String resourceName(String string) {
        if (string != null) {
            String string2 = string.replace(".", "/");
            if ((string2 = string2.replace("\\", "/")).startsWith("/")) {
                string2 = string2.substring(1);
            }
            return string2;
        }
        return null;
    }

    private static Collection<URL> distinctUrls(Collection<URL> collection) {
        LinkedHashMap<String, URL> linkedHashMap = new LinkedHashMap<String, URL>(collection.size());
        for (URL uRL : collection) {
            linkedHashMap.put(uRL.toExternalForm(), uRL);
        }
        return linkedHashMap.values();
    }
}

