/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.adapters.JavaReflectionAdapter;
import org.reflections.adapters.JavassistAdapter;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.serializers.XmlSerializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.FilterBuilder;

public class ConfigurationBuilder
implements Configuration {
    private Set<Scanner> scanners = new HashSet<AbstractScanner>(Arrays.asList(new TypeAnnotationsScanner(), new SubTypesScanner()));
    private Set<URL> urls = new HashSet<URL>();
    protected MetadataAdapter metadataAdapter;
    private Predicate<String> inputsFilter;
    private Serializer serializer;
    private ExecutorService executorService;
    private ClassLoader[] classLoaders;
    private boolean expandSuperTypes = true;

    /*
     * WARNING - void declaration
     */
    public static ConfigurationBuilder build(Object ... objectArray) {
        Object arrayList4;
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (objectArray != null) {
            void e;
            arrayList4 = objectArray;
            int n = ((Object[])arrayList4).length;
            boolean bl = false;
            while (e < n) {
                Object object = arrayList4[e];
                if (object != null) {
                    if (object.getClass().isArray()) {
                        for (Object object2 : (Object[])object) {
                            if (object2 == null) continue;
                            arrayList2.add(object2);
                        }
                    } else if (object instanceof Iterable) {
                        for (Object e2 : (Iterable)object) {
                            if (e2 == null) continue;
                            arrayList2.add(e2);
                        }
                    } else {
                        arrayList2.add(object);
                    }
                }
                ++e;
            }
        }
        arrayList4 = new ArrayList();
        for (Object filterBuilder : arrayList2) {
            if (!(filterBuilder instanceof ClassLoader)) continue;
            arrayList4.add((ClassLoader)filterBuilder);
        }
        Iterator iterator = arrayList4.isEmpty() ? null : arrayList4.toArray(new ClassLoader[arrayList4.size()]);
        FilterBuilder filterBuilder = new FilterBuilder();
        ArrayList<Scanner> arrayList = new ArrayList<Scanner>();
        for (Object e : arrayList2) {
            if (e instanceof String) {
                configurationBuilder.addUrls(ClasspathHelper.forPackage((String)e, iterator));
                filterBuilder.includePackage((String)e);
                continue;
            }
            if (e instanceof Class) {
                if (Scanner.class.isAssignableFrom((Class)e)) {
                    try {
                        configurationBuilder.addScanners((Scanner)((Class)e).newInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                configurationBuilder.addUrls(ClasspathHelper.forClass((Class)e, iterator));
                filterBuilder.includePackage((Class)e);
                continue;
            }
            if (e instanceof Scanner) {
                arrayList.add((Scanner)e);
                continue;
            }
            if (e instanceof URL) {
                configurationBuilder.addUrls((URL)e);
                continue;
            }
            if (e instanceof ClassLoader) continue;
            if (e instanceof Predicate) {
                filterBuilder.add((Predicate)e);
                continue;
            }
            if (e instanceof ExecutorService) {
                configurationBuilder.setExecutorService((ExecutorService)e);
                continue;
            }
            if (Reflections.log == null) continue;
            throw new ReflectionsException("could not use param " + e);
        }
        if (configurationBuilder.getUrls().isEmpty()) {
            if (iterator != null) {
                configurationBuilder.addUrls(ClasspathHelper.forClassLoader(iterator));
            } else {
                configurationBuilder.addUrls(ClasspathHelper.forClassLoader());
            }
        }
        configurationBuilder.filterInputsBy(filterBuilder);
        if (!arrayList.isEmpty()) {
            configurationBuilder.setScanners(arrayList.toArray(new Scanner[arrayList.size()]));
        }
        if (!arrayList4.isEmpty()) {
            configurationBuilder.addClassLoaders((Collection<ClassLoader>)arrayList4);
        }
        return configurationBuilder;
    }

    public ConfigurationBuilder forPackages(String ... stringArray) {
        for (String string : stringArray) {
            this.addUrls(ClasspathHelper.forPackage(string, new ClassLoader[0]));
        }
        return this;
    }

    @Override
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scannerArray) {
        this.scanners.clear();
        return this.addScanners(scannerArray);
    }

    public ConfigurationBuilder addScanners(Scanner ... scannerArray) {
        this.scanners.addAll(Arrays.asList(scannerArray));
        return this;
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(Collection<URL> collection) {
        this.urls = new HashSet<URL>(collection);
        return this;
    }

    public ConfigurationBuilder setUrls(URL ... uRLArray) {
        this.urls = new HashSet<URL>(Arrays.asList(uRLArray));
        return this;
    }

    public ConfigurationBuilder addUrls(Collection<URL> collection) {
        this.urls.addAll(collection);
        return this;
    }

    public ConfigurationBuilder addUrls(URL ... uRLArray) {
        this.urls.addAll(new HashSet<URL>(Arrays.asList(uRLArray)));
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        if (this.metadataAdapter != null) {
            return this.metadataAdapter;
        }
        try {
            this.metadataAdapter = new JavassistAdapter();
            return this.metadataAdapter;
        }
        catch (Throwable throwable) {
            if (Reflections.log != null) {
                Reflections.log.warn("could not create JavassistAdapter, using JavaReflectionAdapter", throwable);
            }
            this.metadataAdapter = new JavaReflectionAdapter();
            return this.metadataAdapter;
        }
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    public Predicate<String> getInputsFilter() {
        return this.inputsFilter;
    }

    public void setInputsFilter(Predicate<String> predicate) {
        this.inputsFilter = predicate;
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> predicate) {
        this.inputsFilter = predicate;
        return this;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(int n) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("org.reflections-scanner-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };
        this.setExecutorService(Executors.newFixedThreadPool(n, threadFactory));
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer != null ? this.serializer : (this.serializer = new XmlSerializer());
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public boolean shouldExpandSuperTypes() {
        return this.expandSuperTypes;
    }

    public ConfigurationBuilder setExpandSuperTypes(boolean bl) {
        this.expandSuperTypes = bl;
        return this;
    }

    public void setClassLoaders(ClassLoader[] classLoaderArray) {
        this.classLoaders = classLoaderArray;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaderArray) {
        this.classLoaders = this.classLoaders == null ? classLoaderArray : (ClassLoader[])Stream.concat(Stream.concat(Arrays.stream(this.classLoaders), Arrays.stream(classLoaderArray)), Stream.of(ClassLoader.class)).distinct().toArray(ClassLoader[]::new);
        return this;
    }

    public ConfigurationBuilder addClassLoaders(Collection<ClassLoader> collection) {
        return this.addClassLoaders(collection.toArray(new ClassLoader[collection.size()]));
    }
}

