/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Utils {
    public static String repeat(String string, int n2) {
        return IntStream.range(0, n2).mapToObj(n -> string).collect(Collectors.joining());
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static File prepareFile(String string) {
        File file = new File(string);
        File file2 = file.getAbsoluteFile().getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return file;
    }

    public static Member getMemberFromDescriptor(String string2, ClassLoader ... classLoaderArray) {
        Object object;
        int n = string2.lastIndexOf(40);
        String string3 = n != -1 ? string2.substring(0, n) : string2;
        String string4 = n != -1 ? string2.substring(n + 1, string2.lastIndexOf(41)) : "";
        int n2 = Math.max(string3.lastIndexOf(46), string3.lastIndexOf("$"));
        String string5 = string3.substring(string3.lastIndexOf(32) + 1, n2);
        String string6 = string3.substring(n2 + 1);
        Class[] classArray = null;
        if (!Utils.isEmpty(string4)) {
            object = string4.split(",");
            classArray = (Class[])Arrays.stream(object).map(string -> ReflectionUtils.forName(string.trim(), classLoaderArray)).toArray(Class[]::new);
        }
        for (object = ReflectionUtils.forName(string5, classLoaderArray); object != null; object = ((Class)object).getSuperclass()) {
            try {
                if (!string2.contains("(")) {
                    return ((Class)object).isInterface() ? ((Class)object).getField(string6) : ((Class)object).getDeclaredField(string6);
                }
                if (Utils.isConstructor(string2)) {
                    return ((Class)object).isInterface() ? ((Class)object).getConstructor(classArray) : ((Class)object).getDeclaredConstructor(classArray);
                }
                return ((Class)object).isInterface() ? ((Class)object).getMethod(string6, classArray) : ((Class)object).getDeclaredMethod(string6, classArray);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new ReflectionsException("Can't resolve member named " + string6 + " for class " + string5);
    }

    public static Set<Method> getMethodsFromDescriptors(Iterable<String> iterable, ClassLoader ... classLoaderArray) {
        HashSet<Method> hashSet = new HashSet<Method>();
        for (String string : iterable) {
            Method method;
            if (Utils.isConstructor(string) || (method = (Method)Utils.getMemberFromDescriptor(string, classLoaderArray)) == null) continue;
            hashSet.add(method);
        }
        return hashSet;
    }

    public static Set<Constructor> getConstructorsFromDescriptors(Iterable<String> iterable, ClassLoader ... classLoaderArray) {
        HashSet<Constructor> hashSet = new HashSet<Constructor>();
        for (String string : iterable) {
            Constructor constructor;
            if (!Utils.isConstructor(string) || (constructor = (Constructor)Utils.getMemberFromDescriptor(string, classLoaderArray)) == null) continue;
            hashSet.add(constructor);
        }
        return hashSet;
    }

    public static Set<Member> getMembersFromDescriptors(Iterable<String> iterable, ClassLoader ... classLoaderArray) {
        HashSet<Member> hashSet = new HashSet<Member>();
        for (String string : iterable) {
            try {
                hashSet.add(Utils.getMemberFromDescriptor(string, classLoaderArray));
            }
            catch (ReflectionsException reflectionsException) {
                throw new ReflectionsException("Can't resolve member named " + string, reflectionsException);
            }
        }
        return hashSet;
    }

    public static Field getFieldFromString(String string, ClassLoader ... classLoaderArray) {
        String string2 = string.substring(0, string.lastIndexOf(46));
        String string3 = string.substring(string.lastIndexOf(46) + 1);
        try {
            return ReflectionUtils.forName(string2, classLoaderArray).getDeclaredField(string3);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionsException("Can't resolve field named " + string3, noSuchFieldException);
        }
    }

    public static void close(InputStream inputStream) {
        block3: {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                if (Reflections.log == null) break block3;
                Reflections.log.warn("Could not close InputStream", (Throwable)iOException);
            }
        }
    }

    public static Logger findLogger(Class<?> clazz) {
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            return LoggerFactory.getLogger(clazz);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isConstructor(String string) {
        return string.contains("init>");
    }

    public static String name(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        return clazz.getName() + Utils.repeat("[]", n);
    }

    public static List<String> names(Collection<Class<?>> collection) {
        return collection.stream().map(Utils::name).collect(Collectors.toList());
    }

    public static List<String> names(Class<?> ... classArray) {
        return Utils.names(Arrays.asList(classArray));
    }

    public static String name(Constructor constructor) {
        return constructor.getName() + ".<init>(" + Utils.join(Utils.names(constructor.getParameterTypes()), ", ") + ")";
    }

    public static String name(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName() + "(" + Utils.join(Utils.names(method.getParameterTypes()), ", ") + ")";
    }

    public static String name(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }

    public static String index(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public static <T> Predicate<T> and(Predicate ... predicateArray) {
        return Arrays.stream(predicateArray).reduce(object -> true, Predicate::and);
    }

    public static String join(Collection<?> collection, String string) {
        return collection.stream().map(Object::toString).collect(Collectors.joining(string));
    }

    public static <T> Set<T> filter(Collection<T> collection, Predicate<? super T> ... predicateArray) {
        return collection.stream().filter(Utils.and(predicateArray)).collect(Collectors.toSet());
    }

    public static <T> Set<T> filter(Collection<T> collection, Predicate<? super T> predicate) {
        return collection.stream().filter(predicate).collect(Collectors.toSet());
    }

    public static <T> Set<T> filter(T[] TArray, Predicate<? super T> ... predicateArray) {
        return Arrays.stream(TArray).filter(Utils.and(predicateArray)).collect(Collectors.toSet());
    }
}

