/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.reflections.ReflectionsException;
import org.reflections.util.Utils;
import org.reflections.vfs.JarInputFile;
import org.reflections.vfs.Vfs;

public class JarInputDir
implements Vfs.Dir {
    private final URL url;
    JarInputStream jarInputStream;
    long cursor = 0L;
    long nextCursor = 0L;

    public JarInputDir(URL uRL) {
        this.url = uRL;
    }

    @Override
    public String getPath() {
        return this.url.getPath();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return () -> new Iterator<Vfs.File>(){
            Vfs.File entry;
            {
                try {
                    JarInputDir.this.jarInputStream = new JarInputStream(JarInputDir.this.url.openConnection().getInputStream());
                }
                catch (Exception exception) {
                    throw new ReflectionsException("Could not open url connection", exception);
                }
                this.entry = null;
            }

            @Override
            public boolean hasNext() {
                return this.entry != null || (this.entry = this.computeNext()) != null;
            }

            @Override
            public Vfs.File next() {
                Vfs.File file = this.entry;
                this.entry = null;
                return file;
            }

            private Vfs.File computeNext() {
                try {
                    JarEntry jarEntry;
                    do {
                        if ((jarEntry = JarInputDir.this.jarInputStream.getNextJarEntry()) == null) {
                            return null;
                        }
                        long l = jarEntry.getSize();
                        if (l < 0L) {
                            l = 0xFFFFFFFFL + l;
                        }
                        JarInputDir.this.nextCursor += l;
                    } while (jarEntry.isDirectory());
                    return new JarInputFile(jarEntry, JarInputDir.this, JarInputDir.this.cursor, JarInputDir.this.nextCursor);
                }
                catch (IOException iOException) {
                    throw new ReflectionsException("could not get next zip entry", iOException);
                }
            }
        };
    }

    @Override
    public void close() {
        Utils.close(this.jarInputStream);
    }
}

