/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.Utils;
import org.reflections.vfs.JarInputDir;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.UrlTypeVFS;
import org.reflections.vfs.ZipDir;

public abstract class Vfs {
    private static List<UrlType> defaultUrlTypes = new ArrayList<DefaultUrlTypes>(Arrays.asList(DefaultUrlTypes.values()));

    public static List<UrlType> getDefaultUrlTypes() {
        return defaultUrlTypes;
    }

    public static void setDefaultURLTypes(List<UrlType> list) {
        defaultUrlTypes = list;
    }

    public static void addDefaultURLTypes(UrlType urlType) {
        defaultUrlTypes.add(0, urlType);
    }

    public static Dir fromURL(URL uRL) {
        return Vfs.fromURL(uRL, defaultUrlTypes);
    }

    public static Dir fromURL(URL uRL, List<UrlType> list) {
        for (UrlType urlType : list) {
            try {
                Dir dir;
                if (!urlType.matches(uRL) || (dir = urlType.createDir(uRL)) == null) continue;
                return dir;
            }
            catch (Throwable throwable) {
                if (Reflections.log == null) continue;
                Reflections.log.warn("could not create Dir using " + urlType + " from url " + uRL.toExternalForm() + ". skipping.", throwable);
            }
        }
        throw new ReflectionsException("could not create Vfs.Dir from url, no matching UrlType was found [" + uRL.toExternalForm() + "]\neither use fromURL(final URL url, final List<UrlType> urlTypes) or use the static setDefaultURLTypes(final List<UrlType> urlTypes) or addDefaultURLTypes(UrlType urlType) with your specialized UrlType.");
    }

    public static Dir fromURL(URL uRL, UrlType ... urlTypeArray) {
        return Vfs.fromURL(uRL, Arrays.asList(urlTypeArray));
    }

    public static Iterable<File> findFiles(Collection<URL> collection, String string, Predicate<String> predicate) {
        Predicate<File> predicate2 = file -> {
            String string2 = file.getRelativePath();
            if (string2.startsWith(string)) {
                String string3 = string2.substring(string2.indexOf(string) + string.length());
                return !Utils.isEmpty(string3) && predicate.test(string3.substring(1));
            }
            return false;
        };
        return Vfs.findFiles(collection, predicate2);
    }

    public static Iterable<File> findFiles(Collection<URL> collection, Predicate<File> predicate) {
        return () -> collection.stream().flatMap(uRL -> {
            try {
                return StreamSupport.stream(Vfs.fromURL(uRL).getFiles().spliterator(), false);
            }
            catch (Throwable throwable) {
                if (Reflections.log != null) {
                    Reflections.log.error("could not findFiles for url. continuing. [" + uRL + "]", throwable);
                }
                return Stream.of(new File[0]);
            }
        }).filter(predicate).iterator();
    }

    public static java.io.File getFile(URL uRL) {
        java.io.File file;
        String string;
        try {
            string = uRL.toURI().getSchemeSpecificPart();
            file = new java.io.File(string);
            if (file.exists()) {
                return file;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            string = URLDecoder.decode(uRL.getPath(), "UTF-8");
            if (string.contains(".jar!")) {
                string = string.substring(0, string.lastIndexOf(".jar!") + ".jar".length());
            }
            if ((file = new java.io.File(string)).exists()) {
                return file;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            string = uRL.toExternalForm();
            if (string.startsWith("jar:")) {
                string = string.substring("jar:".length());
            }
            if (string.startsWith("wsjar:")) {
                string = string.substring("wsjar:".length());
            }
            if (string.startsWith("file:")) {
                string = string.substring("file:".length());
            }
            if (string.contains(".jar!")) {
                string = string.substring(0, string.indexOf(".jar!") + ".jar".length());
            }
            if (string.contains(".war!")) {
                string = string.substring(0, string.indexOf(".war!") + ".war".length());
            }
            if ((file = new java.io.File(string)).exists()) {
                return file;
            }
            file = new java.io.File(string = string.replace("%20", " "));
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean hasJarFileInPath(URL uRL) {
        return uRL.toExternalForm().matches(".*\\.jar(\\!.*|$)");
    }

    public static enum DefaultUrlTypes implements UrlType
    {
        jarFile{

            @Override
            public boolean matches(URL uRL) {
                return uRL.getProtocol().equals("file") && Vfs.hasJarFileInPath(uRL);
            }

            @Override
            public Dir createDir(URL uRL) {
                return new ZipDir(new JarFile(Vfs.getFile(uRL)));
            }
        }
        ,
        jarUrl{

            @Override
            public boolean matches(URL uRL) {
                return "jar".equals(uRL.getProtocol()) || "zip".equals(uRL.getProtocol()) || "wsjar".equals(uRL.getProtocol());
            }

            @Override
            public Dir createDir(URL uRL) {
                Object object;
                try {
                    object = uRL.openConnection();
                    if (object instanceof JarURLConnection) {
                        ((URLConnection)object).setUseCaches(false);
                        return new ZipDir(((JarURLConnection)object).getJarFile());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object = Vfs.getFile(uRL);
                if (object != null) {
                    return new ZipDir(new JarFile((java.io.File)object));
                }
                return null;
            }
        }
        ,
        directory{

            @Override
            public boolean matches(URL uRL) {
                if (uRL.getProtocol().equals("file") && !Vfs.hasJarFileInPath(uRL)) {
                    java.io.File file = Vfs.getFile(uRL);
                    return file != null && file.isDirectory();
                }
                return false;
            }

            @Override
            public Dir createDir(URL uRL) {
                return new SystemDir(Vfs.getFile(uRL));
            }
        }
        ,
        jboss_vfs{

            @Override
            public boolean matches(URL uRL) {
                return uRL.getProtocol().equals("vfs");
            }

            @Override
            public Dir createDir(URL uRL) {
                Object object = uRL.openConnection().getContent();
                Class<?> clazz = ClasspathHelper.contextClassLoader().loadClass("org.jboss.vfs.VirtualFile");
                java.io.File file = (java.io.File)clazz.getMethod("getPhysicalFile", new Class[0]).invoke(object, new Object[0]);
                String string = (String)clazz.getMethod("getName", new Class[0]).invoke(object, new Object[0]);
                java.io.File file2 = new java.io.File(file.getParentFile(), string);
                if (!file2.exists() || !file2.canRead()) {
                    file2 = file;
                }
                return file2.isDirectory() ? new SystemDir(file2) : new ZipDir(new JarFile(file2));
            }
        }
        ,
        jboss_vfsfile{

            @Override
            public boolean matches(URL uRL) {
                return "vfszip".equals(uRL.getProtocol()) || "vfsfile".equals(uRL.getProtocol());
            }

            @Override
            public Dir createDir(URL uRL) {
                return new UrlTypeVFS().createDir(uRL);
            }
        }
        ,
        bundle{

            @Override
            public boolean matches(URL uRL) {
                return uRL.getProtocol().startsWith("bundle");
            }

            @Override
            public Dir createDir(URL uRL) {
                return Vfs.fromURL((URL)ClasspathHelper.contextClassLoader().loadClass("org.eclipse.core.runtime.FileLocator").getMethod("resolve", URL.class).invoke(null, uRL));
            }
        }
        ,
        jarInputStream{

            @Override
            public boolean matches(URL uRL) {
                return uRL.toExternalForm().contains(".jar");
            }

            @Override
            public Dir createDir(URL uRL) {
                return new JarInputDir(uRL);
            }
        };

    }

    public static interface UrlType {
        public boolean matches(URL var1) throws Exception;

        public Dir createDir(URL var1) throws Exception;
    }

    public static interface File {
        public String getName();

        public String getRelativePath();

        public InputStream openInputStream() throws IOException;
    }

    public static interface Dir {
        public String getPath();

        public Iterable<File> getFiles();

        public void close();
    }
}

