/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemUtils {
    public static ItemStack getItem(Material material, int n, boolean bl) {
        return ItemUtils.getItem(material, n, bl, null, null);
    }

    public static ItemStack getItem(Material material, int n, boolean bl, String string) {
        return ItemUtils.getItem(material, n, bl, string, null);
    }

    public static ItemStack getItem(Material material, int n, boolean bl, String string, List<String> list) {
        ItemStack itemStack = new ItemStack(material, n);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        if (string != null) {
            itemMeta.setDisplayName(string);
        }
        if (list != null) {
            itemMeta.setLore(list);
        }
        itemStack.setItemMeta(itemMeta);
        if (bl) {
            ItemUtils.hideAttributes(itemStack);
        }
        return itemStack;
    }

    public static void setName(ItemStack itemStack, String string) {
        if (itemStack == null || string == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        itemStack.setItemMeta(itemMeta);
    }

    public static void setLore(ItemStack itemStack, List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
    }

    public static void setArmorColor(ItemStack itemStack, int n, int n2, int n3) {
        ItemUtils.setArmorColor(itemStack, Color.fromBGR((int)n, (int)n2, (int)n3));
    }

    public static void setArmorColor(ItemStack itemStack, Color color) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof LeatherArmorMeta)) {
            return;
        }
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
        leatherArmorMeta.setColor(color);
        itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
    }

    public static void setDurability(ItemStack itemStack, int n) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            damageable.setDamage(n);
            itemStack.setItemMeta(itemMeta);
        }
    }

    public static void hideAttributes(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.addItemFlags(ItemFlag.values());
        itemStack.setItemMeta(itemMeta);
    }

    public static void showAttributes(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.removeItemFlags(ItemFlag.values());
        itemStack.setItemMeta(itemMeta);
    }

    public static Item dropItem(Plugin plugin, Location location, ItemStack itemStack, int n) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        final Item item = location.getWorld().dropItem(location, itemStack);
        new BukkitRunnable(){

            public void run() {
                item.remove();
            }
        }.runTaskLater(plugin, (long)n);
        return item;
    }

    public static boolean isArmor(Material material) {
        Material[] materialArray = new Material[]{Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS};
        return Arrays.asList(materialArray).contains(material);
    }

    public static boolean isHelmet(Material material) {
        Material[] materialArray = new Material[]{Material.LEATHER_HELMET, Material.CHAINMAIL_HELMET, Material.IRON_HELMET, Material.GOLDEN_HELMET, Material.DIAMOND_HELMET, Material.NETHERITE_HELMET};
        return Arrays.asList(materialArray).contains(material);
    }

    public static boolean isChestPlate(Material material) {
        Material[] materialArray = new Material[]{Material.LEATHER_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.IRON_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.NETHERITE_CHESTPLATE};
        return Arrays.asList(materialArray).contains(material);
    }

    public static boolean isLeggings(Material material) {
        Material[] materialArray = new Material[]{Material.LEATHER_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.IRON_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.NETHERITE_LEGGINGS};
        return Arrays.asList(materialArray).contains(material);
    }

    public static boolean isBoots(Material material) {
        Material[] materialArray = new Material[]{Material.LEATHER_BOOTS, Material.CHAINMAIL_BOOTS, Material.IRON_BOOTS, Material.GOLDEN_BOOTS, Material.DIAMOND_BOOTS, Material.NETHERITE_BOOTS};
        return Arrays.asList(materialArray).contains(material);
    }
}

