/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;

public class LocationUtils {
    public static Location setSolidLocation(Location location, BlockFace blockFace) {
        if (location == null) {
            return null;
        }
        Location location2 = location.clone();
        if (location2.getWorld() == null) {
            return null;
        }
        int n = blockFace == BlockFace.UP ? 1 : -1;
        for (int i = 0; i < location2.getWorld().getMaxHeight() && location.getBlock().isEmpty(); ++i) {
            location.add(0.0, (double)n, 0.0);
        }
        return location.add(0.0, (double)(-n), 0.0);
    }

    public static Location setSolidBlock(Location location, BlockFace blockFace) {
        return LocationUtils.setSolidLocation(location, blockFace).add(0.0, blockFace == BlockFace.UP ? 1.0 : -1.0, 0.0);
    }

    public static Location setAirLocation(Location location, BlockFace blockFace) {
        if (location == null) {
            return null;
        }
        Location location2 = location.clone();
        if (location2.getWorld() == null) {
            return null;
        }
        int n = blockFace == BlockFace.UP ? 1 : -1;
        for (int i = 0; i < location2.getWorld().getMaxHeight() && !location.getBlock().isEmpty(); ++i) {
            location.add(0.0, (double)n, 0.0);
        }
        return location.add(0.0, (double)(-n), 0.0);
    }

    public static Location setAirBlock(Location location, BlockFace blockFace) {
        return LocationUtils.setAirLocation(location, blockFace).add(0.0, blockFace == BlockFace.UP ? 1.0 : -1.0, 0.0);
    }

    public static Location readLongFromConfig(FileConfiguration fileConfiguration, String string) {
        String string2;
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string2 = fileConfiguration.getString(string + ".world")) == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)string2);
        if (world == null) {
            return null;
        }
        double d = fileConfiguration.getDouble(string + ".x");
        double d2 = fileConfiguration.getDouble(string + ".y");
        double d3 = fileConfiguration.getDouble(string + ".z");
        float f = (float)fileConfiguration.getDouble(string + ".yaw");
        float f2 = (float)fileConfiguration.getDouble(string + ".pitch");
        return new Location(world, d, d2, d3, f, f2);
    }

    public static void writeLongToConfig(FileConfiguration fileConfiguration, String string, Location location) {
        World world;
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((world = location.getWorld()) == null) {
            return;
        }
        fileConfiguration.set(string + ".world", (Object)world.getName());
        fileConfiguration.set(string + ".x", (Object)location.getX());
        fileConfiguration.set(string + ".y", (Object)location.getY());
        fileConfiguration.set(string + ".z", (Object)location.getZ());
        fileConfiguration.set(string + ".yaw", (Object)Float.valueOf(location.getYaw()));
        fileConfiguration.set(string + ".pitch", (Object)Float.valueOf(location.getPitch()));
    }

    public static Location readShortFromConfig(FileConfiguration fileConfiguration, String string) {
        String string2 = fileConfiguration.getString(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(";");
        if (stringArray.length != 6) {
            return null;
        }
        World world = Bukkit.getWorld((String)stringArray[0]);
        if (world == null) {
            return null;
        }
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        double d3 = Double.parseDouble(stringArray[3]);
        float f = Float.parseFloat(stringArray[4]);
        float f2 = Float.parseFloat(stringArray[5]);
        return new Location(world, d, d2, d3, f, f2);
    }

    public static void writeShortToConfig(FileConfiguration fileConfiguration, String string, Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        String string2 = String.format("%s;%.2f;%.2f;%.2f;%.2f;%.2f", world.getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        fileConfiguration.set(string, (Object)string2);
    }

    public static List<Location> getCircle(Location location, double d, int n) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (location == null || location.getWorld() == null) {
            return arrayList;
        }
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i * d2;
            double d4 = location.getX() + d * Math.cos(d3);
            double d5 = location.getZ() + d * Math.sin(d3);
            arrayList.add(new Location(location.getWorld(), d4, location.getY(), d5));
        }
        return arrayList;
    }

    public static List<Block> getCube(Location location, int n) {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        if (location == null || location.getWorld() == null) {
            return arrayList;
        }
        int n2 = location.getBlockX() - n / 2;
        int n3 = location.getBlockY() - n / 2;
        int n4 = location.getBlockZ() - n / 2;
        for (int i = n2; i < n2 + n; ++i) {
            for (int j = n3; j < n3 + n; ++j) {
                for (int k = n4; k < n4 + n; ++k) {
                    arrayList.add(location.getWorld().getBlockAt(i, j, k));
                }
            }
        }
        return arrayList;
    }

    public static List<Location> getSphere(Location location, int n) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (location == null || location.getWorld() == null) {
            return arrayList;
        }
        int n2 = location.getBlockX();
        int n3 = location.getBlockY();
        int n4 = location.getBlockZ();
        int n5 = n * n;
        for (int i = n2 - n; i <= n2 + n; ++i) {
            for (int j = n3 - n; j <= n3 + n; ++j) {
                for (int k = n4 - n; k <= n4 + n; ++k) {
                    if ((n2 - i) * (n2 - i) + (n4 - k) * (n4 - k) > n5) continue;
                    Location location2 = new Location(location.getWorld(), (double)i, (double)j, (double)k);
                    arrayList.add(location2);
                }
            }
        }
        return arrayList;
    }

    public static List<Location> getSphere(Location location, int n, boolean bl) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (location == null || location.getWorld() == null) {
            return arrayList;
        }
        int n2 = location.getBlockX();
        int n3 = location.getBlockY();
        int n4 = location.getBlockZ();
        int n5 = n * n;
        int n6 = bl ? (n - 1) * (n - 1) : n5;
        for (int i = n2 - n; i <= n2 + n; ++i) {
            for (int j = n3 - n; j <= n3 + n; ++j) {
                for (int k = n4 - n; k <= n4 + n; ++k) {
                    int n7 = (n2 - i) * (n2 - i) + (n3 - j) * (n3 - j) + (n4 - k) * (n4 - k);
                    if (n7 > n5 || n7 < n6) continue;
                    Location location2 = new Location(location.getWorld(), (double)i, (double)j, (double)k);
                    arrayList.add(location2);
                }
            }
        }
        return arrayList;
    }
}

