/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api;

import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.object.nameplate.NameplatesTeam;
import org.bukkit.entity.Player;

public class CustomNameplatesAPI {
    private static CustomNameplatesAPI api;
    private final CustomNameplates plugin;

    public CustomNameplatesAPI(CustomNameplates plugin) {
        this.plugin = plugin;
    }

    public void init() {
        api = this;
    }

    public static CustomNameplatesAPI getInstance() {
        return api;
    }

    @Deprecated
    public static CustomNameplatesAPI getAPI() {
        return api;
    }

    public boolean doesNameplateExist(String nameplate) {
        return this.plugin.getNameplateManager().existNameplate(nameplate);
    }

    public boolean doesBubbleExist(String bubble) {
        return this.plugin.getChatBubblesManager().existBubble(bubble);
    }

    public void equipNameplate(Player player, String nameplate) {
        this.plugin.getDataManager().equipNameplate(player, nameplate);
        this.updateAndSave(player);
    }

    private void updateAndSave(Player player) {
        this.updateNameplateTeam(player);
        this.plugin.getScheduler().runTaskAsync(() -> this.plugin.getDataManager().saveData(player));
    }

    public void equipBubble(Player player, String bubble) {
        this.plugin.getDataManager().equipBubble(player, bubble);
        this.plugin.getScheduler().runTaskAsync(() -> this.plugin.getDataManager().saveData(player));
    }

    public void unEquipNameplate(Player player) {
        this.plugin.getDataManager().equipNameplate(player, "none");
        this.updateAndSave(player);
    }

    public void unEquipBubble(Player player) {
        this.plugin.getDataManager().equipBubble(player, "none");
        this.plugin.getScheduler().runTaskAsync(() -> this.plugin.getDataManager().saveData(player));
    }

    public void updateNameplateTeam(Player player) {
        NameplatesTeam nameplatesTeam = this.plugin.getTeamManager().getNameplateTeam(player.getUniqueId());
        if (nameplatesTeam != null) {
            nameplatesTeam.update(true);
            this.plugin.getTeamManager().sendUpdateToAll(player, true);
        }
    }
}

