/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.command.subcmd;

import java.util.List;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.command.AbstractSubCommand;
import net.momirealms.customnameplates.libs.net.kyori.adventure.key.Key;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.Component;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.TextComponent;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.format.TextColor;
import net.momirealms.customnameplates.manager.MessageManager;
import net.momirealms.customnameplates.manager.NameplateManager;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.nameplate.NameplateConfig;
import net.momirealms.customnameplates.object.nameplate.NameplatesTeam;
import net.momirealms.customnameplates.utils.AdventureUtils;
import net.momirealms.customnameplates.utils.ArmorStandUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ForcePreviewCommand
extends AbstractSubCommand {
    public static final AbstractSubCommand INSTANCE = new ForcePreviewCommand();

    public ForcePreviewCommand() {
        super("forcepreview");
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        if (this.lackArgs(sender, 1, args.size()) || this.playerNotOnline(sender, args.get(0))) {
            return true;
        }
        Player player = Bukkit.getPlayer((String)args.get(0));
        assert (player != null);
        NameplateManager nameplateManager = CustomNameplates.getInstance().getNameplateManager();
        if (nameplateManager.isInCoolDown(player)) {
            AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.coolDown);
            return true;
        }
        String nameplate = args.size() >= 2 ? args.get(1) : nameplateManager.getEquippedNameplate(player);
        NameplateConfig nameplateConfig = nameplateManager.getNameplateConfig(nameplate);
        if (nameplateConfig == null) {
            AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.np_not_exist);
            return true;
        }
        if (nameplateManager.getMode() == DisplayMode.TEAM) {
            NameplatesTeam team = CustomNameplates.getInstance().getTeamManager().getNameplateTeam(player.getUniqueId());
            if (team != null) {
                Component full = team.getNameplatePrefixComponent().append(((TextComponent)Component.text(player.getName()).color(TextColor.color(AdventureUtils.colorToDecimal(team.getColor())))).font(Key.key("minecraft:default")).append(team.getNameplateSuffixComponent()));
                ArmorStandUtils.preview(full, player, (int)nameplateManager.getPreview_time());
            }
        } else if (nameplateManager.getMode() == DisplayMode.ARMOR_STAND || nameplateManager.getMode() == DisplayMode.TEXT_DISPLAY) {
            nameplateManager.showPlayerArmorStandTags(player, nameplate);
        } else {
            AdventureUtils.sendMessage(sender, MessageManager.prefix + "<white>Nameplate is disabled.");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, List<String> args) {
        if (args.size() == 1) {
            return this.filterStartingWith(this.online_players(), args.get(0));
        }
        if (args.size() == 2) {
            return this.filterStartingWith(this.allNameplates(), args.get(1));
        }
        return null;
    }
}

