/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.data;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import java.sql.Connection;
import java.sql.SQLException;
import net.momirealms.customnameplates.data.MySQLStorageImpl;
import net.momirealms.customnameplates.utils.AdventureUtils;
import net.momirealms.customnameplates.utils.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SqlConnection {
    private boolean secondTry = false;
    private boolean firstTry = false;
    private HikariDataSource hikariDataSource;
    private String table;
    private final MySQLStorageImpl mySQLStorage;

    public SqlConnection(MySQLStorageImpl mySQLStorage) {
        this.mySQLStorage = mySQLStorage;
    }

    public void createNewHikariConfiguration() {
        ConfigUtils.update("database.yml");
        YamlConfiguration config = ConfigUtils.getConfig("database.yml");
        String storageMode = config.getString("data-storage-method", "MySQL");
        HikariConfig hikariConfig = new HikariConfig();
        String sql = "mysql";
        if (storageMode.equalsIgnoreCase("MariaDB")) {
            try {
                Class.forName("org.mariadb.jdbc.Driver");
            }
            catch (ClassNotFoundException e1) {
                AdventureUtils.consoleMessage("<red>[CustomNameplates] No sql driver is found.");
            }
            hikariConfig.setDriverClassName("org.mariadb.jdbc.Driver");
            sql = "mariadb";
        } else {
            try {
                Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException e1) {
                try {
                    Class.forName("com.mysql.cj.jdbc.Driver");
                }
                catch (ClassNotFoundException e2) {
                    AdventureUtils.consoleMessage("<red>[CustomNameplates] No sql driver is found.");
                }
            }
        }
        this.table = config.getString(storageMode + ".table");
        hikariConfig.setPoolName("[CustomNameplates]");
        hikariConfig.setJdbcUrl(String.format("jdbc:%s://%s/%s", sql, config.getString(storageMode + ".host") + ":" + config.getString(storageMode + ".port"), config.getString(storageMode + ".database")));
        hikariConfig.setUsername(config.getString(storageMode + ".user"));
        hikariConfig.setPassword(config.getString(storageMode + ".password"));
        hikariConfig.setMaximumPoolSize(config.getInt(storageMode + ".Pool-Settings.maximum-pool-size"));
        hikariConfig.setMinimumIdle(config.getInt(storageMode + ".Pool-Settings.minimum-idle"));
        hikariConfig.setMaxLifetime((long)config.getInt(storageMode + ".Pool-Settings.maximum-lifetime"));
        hikariConfig.setConnectionTimeout(3000L);
        hikariConfig.setIdleTimeout(hikariConfig.getMinimumIdle() < hikariConfig.getMaximumPoolSize() ? (long)config.getInt(storageMode + ".Pool-Settings.idle-timeout") : 0L);
        ConfigurationSection section = config.getConfigurationSection(storageMode + ".properties");
        if (section != null) {
            for (String property : section.getKeys(false)) {
                hikariConfig.addDataSourceProperty(property, (Object)config.getString(storageMode + ".properties." + property));
            }
        }
        try {
            this.hikariDataSource = new HikariDataSource(hikariConfig);
        }
        catch (HikariPool.PoolInitializationException e) {
            AdventureUtils.consoleMessage("[CustomNameplates] Failed to create sql connection");
        }
    }

    public boolean setGlobalConnection() {
        try {
            this.createNewHikariConfiguration();
            Connection connection = this.getConnection();
            connection.close();
            if (this.secondTry) {
                AdventureUtils.consoleMessage("[CustomNameplates] Successfully reconnect to SQL!");
            } else {
                this.secondTry = true;
            }
            return true;
        }
        catch (SQLException e) {
            AdventureUtils.consoleMessage("<red>[CustomNameplates] Error! Failed to connect to SQL!</red>");
            e.printStackTrace();
            this.close();
            return false;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.hikariDataSource.getConnection();
    }

    public boolean canConnect() {
        if (this.hikariDataSource == null) {
            return this.setGlobalConnection();
        }
        if (this.hikariDataSource.isClosed()) {
            return this.setGlobalConnection();
        }
        return true;
    }

    public void close() {
        if (this.hikariDataSource != null && this.hikariDataSource.isRunning()) {
            this.hikariDataSource.close();
        }
    }

    public Connection getConnectionAndCheck() {
        if (!this.canConnect()) {
            return null;
        }
        try {
            return this.getConnection();
        }
        catch (SQLException e) {
            if (this.firstTry) {
                this.firstTry = false;
                this.close();
                return this.getConnectionAndCheck();
            }
            this.firstTry = true;
            AdventureUtils.consoleMessage("<red>[CustomNameplates] Error! Failed to connect to SQL!</red>");
            this.close();
            e.printStackTrace();
            return null;
        }
    }

    public String getTable() {
        return this.table;
    }
}

