/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.helper.Log;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.Bukkit;

public class VersionHelper {
    private boolean isNewerThan1_19_R2;
    private boolean isNewerThan1_20_R2;
    private boolean isNewerThan1_19;
    private boolean isNewerThan1_20;
    private String serverVersion;
    private final CustomNameplates plugin;
    private final String pluginVersion;
    private boolean isLatest;
    private final int pack_format;
    private boolean isFolia;
    private boolean hasGeyser;

    public VersionHelper(CustomNameplates plugin) {
        this.plugin = plugin;
        this.pluginVersion = plugin.getDescription().getVersion();
        this.hasGeyser = Bukkit.getPluginManager().getPlugin("Geyser-Spigot") != null;
        this.initialize();
        this.pack_format = this.getPack_format(this.serverVersion);
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            this.isFolia = true;
        }
        catch (ClassNotFoundException ignored) {
            this.isFolia = false;
        }
    }

    public void initialize() {
        if (this.serverVersion == null) {
            this.serverVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            String[] split = this.serverVersion.split("_");
            int main_ver = Integer.parseInt(split[1]);
            if (main_ver >= 20) {
                this.isNewerThan1_20 = true;
                this.isNewerThan1_19_R2 = true;
                this.isNewerThan1_19 = true;
                this.isNewerThan1_20_R2 = Integer.parseInt(split[2].substring(1)) >= 2;
            } else if (main_ver == 19) {
                this.isNewerThan1_19_R2 = Integer.parseInt(split[2].substring(1)) >= 2;
                this.isNewerThan1_19 = true;
            } else {
                this.isNewerThan1_19_R2 = false;
                this.isNewerThan1_19 = false;
            }
        }
    }

    public boolean isVersionNewerThan1_19_R2() {
        return this.isNewerThan1_19_R2;
    }

    public boolean isVersionNewerThan1_19() {
        return this.isNewerThan1_19;
    }

    public boolean isVersionNewerThan1_20() {
        return this.isNewerThan1_20;
    }

    public boolean isVersionNewerThan1_20_R2() {
        return this.isNewerThan1_20_R2;
    }

    public void checkUpdate() {
        this.plugin.getScheduler().runTaskAsync(() -> {
            try {
                URL url = new URL("https://api.polymart.org/v1/getResourceInfoSimple/?resource_id=2543&key=version");
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                InputStream inputStream = conn.getInputStream();
                String newest = new BufferedReader(new InputStreamReader(inputStream)).readLine();
                String current = this.plugin.getDescription().getVersion();
                inputStream.close();
                boolean bl = this.isLatest = !this.compareVer(newest, current);
                if (this.isLatest) {
                    AdventureUtils.consoleMessage(ConfigManager.lang.equalsIgnoreCase("chinese") ? "[CustomNameplates] \u5f53\u524d\u5df2\u662f\u6700\u65b0\u7248\u672c" : "[CustomNameplates] You are using the latest version.");
                    return;
                }
                if (ConfigManager.lang.equalsIgnoreCase("chinese")) {
                    AdventureUtils.consoleMessage("[CustomNameplates] \u5f53\u524d\u7248\u672c: <red>" + current);
                    AdventureUtils.consoleMessage("[CustomNameplates] \u6700\u65b0\u7248\u672c: <green>" + newest);
                    AdventureUtils.consoleMessage("[CustomNameplates] \u8bf7\u5230 <u>\u552e\u540e\u7fa4<!u> \u6216 <u>https://polymart.org/resource/customnameplates.2543<!u> \u83b7\u53d6\u6700\u65b0\u7248\u672c.");
                } else {
                    AdventureUtils.consoleMessage("[CustomNameplates] Current version: <red>" + current);
                    AdventureUtils.consoleMessage("[CustomNameplates] Latest version: <green>" + newest);
                    AdventureUtils.consoleMessage("[CustomNameplates] Update is available: <u>https://polymart.org/resource/customnameplates.2543<!u>");
                }
            }
            catch (IOException e) {
                this.isLatest = true;
                Log.warn("Error occurred when checking update");
            }
        });
    }

    private int getPack_format(String version) {
        switch (version) {
            case "v1_20_R2": {
                return 18;
            }
            case "v1_20_R1": {
                return 15;
            }
            case "v1_19_R3": {
                return 13;
            }
            case "v1_19_R2": {
                return 12;
            }
            case "v1_19_R1": {
                return 9;
            }
            case "v1_18_R1": 
            case "v1_18_R2": {
                return 8;
            }
        }
        return 7;
    }

    private boolean compareVer(String newV, String currentV) {
        if (newV == null || currentV == null || newV.isEmpty() || currentV.isEmpty()) {
            return false;
        }
        String[] newVS = newV.split("\\.");
        String[] currentVS = currentV.split("\\.");
        int maxL = Math.min(newVS.length, currentVS.length);
        for (int i = 0; i < maxL; ++i) {
            try {
                String[] newPart = newVS[i].split("-");
                String[] currentPart = currentVS[i].split("-");
                int newNum = Integer.parseInt(newPart[0]);
                int currentNum = Integer.parseInt(currentPart[0]);
                if (newNum > currentNum) {
                    return true;
                }
                if (newNum < currentNum) {
                    return false;
                }
                if (newPart.length > 1 && currentPart.length > 1) {
                    int currentHotfixNum;
                    String[] newHotfix = newPart[1].split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                    String[] currentHotfix = currentPart[1].split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                    if (newHotfix.length == 2 && currentHotfix.length == 1) {
                        return true;
                    }
                    if (newHotfix.length <= 1 || currentHotfix.length <= 1) continue;
                    int newHotfixNum = Integer.parseInt(newHotfix[1]);
                    if (newHotfixNum > (currentHotfixNum = Integer.parseInt(currentHotfix[1]))) {
                        return true;
                    }
                    if (newHotfixNum < currentHotfixNum) {
                        return false;
                    }
                    return newHotfix[0].compareTo(currentHotfix[0]) > 0;
                }
                if (newPart.length > 1) {
                    return true;
                }
                if (currentPart.length <= 1) continue;
                return false;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }
        return newVS.length > currentVS.length;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public boolean isLatest() {
        return this.isLatest || !ConfigManager.checkUpdate;
    }

    public int getPack_format() {
        return this.pack_format;
    }

    public boolean isFolia() {
        return this.isFolia;
    }

    public boolean isGeyser() {
        return this.hasGeyser;
    }
}

