/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.listener;

import net.momirealms.customnameplates.object.carrier.NamedEntityCarrier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;

public record EntityTagListener(NamedEntityCarrier namedEntityCarrier) implements Listener
{
    @EventHandler
    public void onSneak(PlayerToggleSneakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.namedEntityCarrier.onSneak(event.getPlayer(), event.isSneaking());
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        this.namedEntityCarrier.onRespawn(event.getPlayer());
    }

    @EventHandler
    public void onExitVehicle(VehicleExitEvent event) {
        if (event.isCancelled()) {
            return;
        }
        LivingEntity livingEntity = event.getExited();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.namedEntityCarrier.onSneak(player, false);
        }
    }
}

