/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.data.DataStorageInterface;
import net.momirealms.customnameplates.data.FileStorageImpl;
import net.momirealms.customnameplates.data.MySQLStorageImpl;
import net.momirealms.customnameplates.data.PlayerData;
import net.momirealms.customnameplates.data.StorageType;
import net.momirealms.customnameplates.listener.JoinQuitListener;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.utils.ConfigUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DataManager
extends Function {
    private final CustomNameplates plugin;
    private DataStorageInterface dataStorageInterface;
    private final JoinQuitListener joinQuitListener;
    private StorageType storageType;
    private final ConcurrentHashMap<UUID, PlayerData> playerDataMap;
    private final ConcurrentHashMap<UUID, Integer> triedTimes;

    public DataManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.playerDataMap = new ConcurrentHashMap();
        this.joinQuitListener = new JoinQuitListener(this);
        this.triedTimes = new ConcurrentHashMap();
    }

    @Override
    public void load() {
        if (this.loadStorageMode()) {
            this.dataStorageInterface.initialize();
        }
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
    }

    @Override
    public void unload() {
        StorageType st;
        YamlConfiguration config = ConfigUtils.getConfig("database.yml");
        StorageType storageType = st = config.getString("data-storage-method", "YAML").equalsIgnoreCase("YAML") ? StorageType.YAML : StorageType.SQL;
        if (this.dataStorageInterface != null && this.dataStorageInterface.getStorageType() != st) {
            this.dataStorageInterface.disable();
        }
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
    }

    @Override
    public void disable() {
        if (this.dataStorageInterface != null) {
            this.dataStorageInterface.disable();
        }
    }

    @Override
    public void onJoin(Player player) {
        this.plugin.getScheduler().runTaskAsync(() -> this.readData(player.getUniqueId()));
    }

    public void readData(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || !player.isOnline() || !this.checkTriedTimes(uuid)) {
            return;
        }
        PlayerData playerData = this.dataStorageInterface.loadData(uuid);
        if (playerData == null) {
            this.plugin.getScheduler().runTaskAsyncLater(() -> this.readData(uuid), 20L);
        } else {
            this.playerDataMap.put(uuid, playerData);
            if (!ConfigManager.enableNameplates || this.plugin.getNameplateManager().getMode() == DisplayMode.DISABLE) {
                return;
            }
            this.plugin.getTeamManager().getTeamNameInterface().onJoin(player);
            this.plugin.getTeamManager().createTeam(uuid);
        }
    }

    @Override
    public void onQuit(Player player) {
        PlayerData playerData = this.playerDataMap.remove(player.getUniqueId());
        if (playerData != null) {
            this.plugin.getScheduler().runTaskAsync(() -> this.dataStorageInterface.saveData(playerData));
        }
        this.plugin.getTeamManager().onQuit(player);
        this.triedTimes.remove(player.getUniqueId());
    }

    public void saveData(Player player) {
        PlayerData playerData = this.playerDataMap.get(player.getUniqueId());
        if (playerData != null) {
            this.plugin.getScheduler().runTaskAsync(() -> this.dataStorageInterface.saveData(playerData));
        }
    }

    public DataStorageInterface getDataStorageInterface() {
        return this.dataStorageInterface;
    }

    private boolean loadStorageMode() {
        YamlConfiguration config = ConfigUtils.getConfig("database.yml");
        if (config.getString("data-storage-method", "YAML").equalsIgnoreCase("YAML")) {
            if (this.storageType != StorageType.YAML) {
                this.dataStorageInterface = new FileStorageImpl(this.plugin);
                this.storageType = StorageType.YAML;
                return true;
            }
        } else if (this.storageType != StorageType.SQL) {
            this.dataStorageInterface = new MySQLStorageImpl(this.plugin);
            this.storageType = StorageType.SQL;
            return true;
        }
        return false;
    }

    public String getEquippedNameplate(Player player) {
        return Optional.ofNullable(this.playerDataMap.get(player.getUniqueId())).orElse(PlayerData.EMPTY).getNameplate();
    }

    public String getEquippedBubble(Player player) {
        return Optional.ofNullable(this.playerDataMap.get(player.getUniqueId())).orElse(PlayerData.EMPTY).getBubble();
    }

    public void equipNameplate(Player player, String nameplate) {
        PlayerData playerData = this.playerDataMap.get(player.getUniqueId());
        if (playerData != null) {
            playerData.setNameplate(nameplate);
        }
    }

    public void equipBubble(Player player, String bubble) {
        PlayerData playerData = this.playerDataMap.get(player.getUniqueId());
        if (playerData != null) {
            playerData.setBubble(bubble);
        }
    }

    protected boolean checkTriedTimes(UUID uuid) {
        Integer previous = this.triedTimes.get(uuid);
        if (previous == null) {
            this.triedTimes.put(uuid, 1);
            return true;
        }
        if (previous > 2) {
            this.triedTimes.remove(uuid);
            return false;
        }
        this.triedTimes.put(uuid, previous + 1);
        return true;
    }
}

