/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Objects;
import javax.imageio.ImageIO;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.helper.Log;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.SimpleChar;
import net.momirealms.customnameplates.object.font.ASCIIWidth;
import net.momirealms.customnameplates.object.font.OffsetFont;
import net.momirealms.customnameplates.object.font.ThinASCIIWidth;
import net.momirealms.customnameplates.utils.AdventureUtils;
import net.momirealms.customnameplates.utils.ConfigUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontManager
extends Function {
    private final CustomNameplates plugin;
    private final HashMap<Character, Integer> customImageWidth;
    private final HashMap<Character, Integer> asciiWidth;

    public FontManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.customImageWidth = new HashMap(1024);
        this.asciiWidth = new HashMap();
    }

    @Override
    public void load() {
        this.saveFonts();
        this.loadASCIIWidth();
        this.loadUnicodesWidth();
        this.loadCustomWidth();
    }

    @Override
    public void unload() {
        this.customImageWidth.clear();
        this.asciiWidth.clear();
    }

    private void loadASCIIWidth() {
        if (ConfigManager.thin_font) {
            for (int i = 0; i < ThinASCIIWidth.values().length; ++i) {
                this.asciiWidth.put(Character.valueOf(ThinASCIIWidth.values()[i].getCharacter()), ThinASCIIWidth.values()[i].getWidth());
            }
        } else {
            for (int i = 0; i < ASCIIWidth.values().length; ++i) {
                this.asciiWidth.put(Character.valueOf(ASCIIWidth.values()[i].getCharacter()), ASCIIWidth.values()[i].getWidth());
            }
        }
    }

    public void loadCustomWidth(char c, int width) {
        this.customImageWidth.put(Character.valueOf(c), width);
    }

    private void loadCustomWidth() {
        for (int i = 0; i < ASCIIWidth.values().length; ++i) {
            this.customImageWidth.put(Character.valueOf(ASCIIWidth.values()[i].getCharacter()), ASCIIWidth.values()[i].getWidth());
        }
        for (SimpleChar simpleChar : this.plugin.getImageManager().getCharacterMap().values()) {
            this.customImageWidth.put(Character.valueOf(simpleChar.getChars()), simpleChar.getWidth());
        }
        for (OffsetFont offsetFont : OffsetFont.values()) {
            this.customImageWidth.put(Character.valueOf(offsetFont.getCharacter()), offsetFont.getSpace() - 1);
        }
        YamlConfiguration config = ConfigUtils.getConfig("configs" + File.separator + "image-width.yml");
        for (String image : config.getKeys(false)) {
            String character = AdventureUtils.stripAllTags(PlaceholderAPI.setPlaceholders(null, (String)image));
            if (character.length() != 1) continue;
            this.customImageWidth.put(Character.valueOf(character.charAt(0)), config.getInt(image, 8));
        }
    }

    private void saveFonts() {
        File font_file = new File(this.plugin.getDataFolder(), "unicodes");
        if (!font_file.exists()) {
            for (int i = 0; i < 256; ++i) {
                this.saveResource("unicodes" + File.separator + "unicode_page_" + String.format("%02x", i) + ".png");
            }
        }
        this.plugin.saveResource("templates" + File.separator + "default.json", true);
        this.plugin.saveResource("templates" + File.separator + "unicode.json", true);
    }

    public String getSuffixStringWithFont(String text) {
        return ConfigManager.surroundWithFont(this.getSuffixString(text));
    }

    public String getSuffixString(String text) {
        int totalWidth = this.plugin.getFontManager().getTotalWidth(text);
        return this.plugin.getFontManager().getShortestNegChars(totalWidth + totalWidth % 2 + 1);
    }

    public int getNameCharWidth(char c) {
        Integer width = this.asciiWidth.get(Character.valueOf(c));
        if (width != null) {
            return width;
        }
        return Objects.requireNonNullElse(this.customImageWidth.get(Character.valueOf(c)), ConfigManager.default_width);
    }

    public int getTotalWidth(String text) {
        int length = text.length();
        int n = 0;
        for (int i = 0; i < length; ++i) {
            char current = text.charAt(i);
            if (current != '\\' || i == length - 1 || text.charAt(i + 1) != '<') {
                n += Objects.requireNonNullElse(this.customImageWidth.get(Character.valueOf(current)), ConfigManager.default_width).intValue();
                continue;
            }
            --n;
        }
        return n + length;
    }

    public int getTotalPlayerNameWidth(String text) {
        int length = text.length();
        int n = 0;
        for (int i = 0; i < length; ++i) {
            n += this.getNameCharWidth(text.charAt(i));
        }
        return n + length;
    }

    public String getOffset(int offset) {
        if (offset >= 0) {
            return this.getShortestPosChars(offset);
        }
        return this.getShortestNegChars(-offset);
    }

    public String getShortestNegChars(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n >= 128) {
            stringBuilder.append(OffsetFont.NEG_128.getCharacter());
            n -= 128;
        }
        if (n - 64 >= 0) {
            stringBuilder.append(OffsetFont.NEG_64.getCharacter());
            n -= 64;
        }
        if (n - 32 >= 0) {
            stringBuilder.append(OffsetFont.NEG_32.getCharacter());
            n -= 32;
        }
        if (n - 16 >= 0) {
            stringBuilder.append(OffsetFont.NEG_16.getCharacter());
            n -= 16;
        }
        if (n - 8 >= 0) {
            stringBuilder.append(OffsetFont.NEG_8.getCharacter());
            n -= 8;
        }
        if (n - 7 >= 0) {
            stringBuilder.append(OffsetFont.NEG_7.getCharacter());
            n -= 7;
        }
        if (n - 6 >= 0) {
            stringBuilder.append(OffsetFont.NEG_6.getCharacter());
            n -= 6;
        }
        if (n - 5 >= 0) {
            stringBuilder.append(OffsetFont.NEG_5.getCharacter());
            n -= 5;
        }
        if (n - 4 >= 0) {
            stringBuilder.append(OffsetFont.NEG_4.getCharacter());
            n -= 4;
        }
        if (n - 3 >= 0) {
            stringBuilder.append(OffsetFont.NEG_3.getCharacter());
            n -= 3;
        }
        if (n - 2 >= 0) {
            stringBuilder.append(OffsetFont.NEG_2.getCharacter());
            n -= 2;
        }
        if (n - 1 >= 0) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
        }
        return stringBuilder.toString();
    }

    public String getShortestPosChars(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n >= 128) {
            stringBuilder.append(OffsetFont.POS_128.getCharacter());
            n -= 128;
        }
        if (n - 64 >= 0) {
            stringBuilder.append(OffsetFont.POS_64.getCharacter());
            n -= 64;
        }
        if (n - 32 >= 0) {
            stringBuilder.append(OffsetFont.POS_32.getCharacter());
            n -= 32;
        }
        if (n - 16 >= 0) {
            stringBuilder.append(OffsetFont.POS_16.getCharacter());
            n -= 16;
        }
        if (n - 8 >= 0) {
            stringBuilder.append(OffsetFont.POS_8.getCharacter());
            n -= 8;
        }
        if (n - 7 >= 0) {
            stringBuilder.append(OffsetFont.POS_7.getCharacter());
            n -= 7;
        }
        if (n - 6 >= 0) {
            stringBuilder.append(OffsetFont.POS_6.getCharacter());
            n -= 6;
        }
        if (n - 5 >= 0) {
            stringBuilder.append(OffsetFont.POS_5.getCharacter());
            n -= 5;
        }
        if (n - 4 >= 0) {
            stringBuilder.append(OffsetFont.POS_4.getCharacter());
            n -= 4;
        }
        if (n - 3 >= 0) {
            stringBuilder.append(OffsetFont.POS_3.getCharacter());
            n -= 3;
        }
        if (n - 2 >= 0) {
            stringBuilder.append(OffsetFont.POS_2.getCharacter());
            n -= 2;
        }
        if (n - 1 >= 0) {
            stringBuilder.append(OffsetFont.POS_1.getCharacter());
        }
        return stringBuilder.toString();
    }

    private void loadUnicodesWidth() {
        File[] files = new File(CustomNameplates.getInstance().getDataFolder(), "unicodes").listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".png")) continue;
            String unicodeStr = file.getName().substring(file.getName().length() - 6, file.getName().length() - 4);
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                int width = bufferedImage.getWidth();
                int height = bufferedImage.getHeight();
                int single = width / 16;
                int max_y = height / single;
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < max_y; ++j) {
                        int x_final = i * single;
                        block5: for (int x = i * single; x < (i + 1) * single; ++x) {
                            for (int y = j * single; y < (j + 1) * single; ++y) {
                                int rgb = bufferedImage.getRGB(x, y);
                                int alpha = rgb >> 24 & 0xFF;
                                if (alpha == 0) continue;
                                x_final = x;
                                continue block5;
                            }
                        }
                        int single_real_width = (int)((double)(x_final - i * single) / (double)single * 8.0 + 1.0);
                        String unicode = "\\u" + unicodeStr + String.format("%02x", i + j * 16);
                        String unicodeFinalStr = StringEscapeUtils.unescapeJava((String)unicode);
                        this.customImageWidth.put(Character.valueOf(unicodeFinalStr.charAt(0)), single_real_width);
                    }
                }
            }
            catch (IOException ignored) {
                Log.warn("Error occurred when reading png files");
            }
        }
    }

    @Nullable
    public InputStream getResource(@NotNull String filename) {
        try {
            URL url = ((Object)((Object)this.plugin)).getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void saveResource(@NotNull String resourcePath) {
        if (resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            return;
        }
        File outFile = new File(this.plugin.getDataFolder(), resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.plugin.getDataFolder(), resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists()) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (IOException ex) {
            Log.warn("Could not save " + outFile.getName() + " to " + outFile);
        }
    }
}

