/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.ConditionalText;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.font.OffsetFont;
import net.momirealms.customnameplates.object.placeholders.BackGroundText;
import net.momirealms.customnameplates.object.placeholders.ConditionalTexts;
import net.momirealms.customnameplates.object.placeholders.DescentText;
import net.momirealms.customnameplates.object.placeholders.NameplatePlaceholders;
import net.momirealms.customnameplates.object.placeholders.NameplateText;
import net.momirealms.customnameplates.object.placeholders.StaticText;
import net.momirealms.customnameplates.object.placeholders.VanillaHud;
import net.momirealms.customnameplates.utils.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlaceholderManager
extends Function {
    private final NameplatePlaceholders nameplatePlaceholders;
    private final Pattern placeholderPattern = Pattern.compile("%([^%]*)%");
    private final HashSet<Integer> descent_fonts;
    private final HashSet<Integer> descent_unicode_fonts;
    private final HashMap<String, NameplateText> nameplateTextMap;
    private final HashMap<String, BackGroundText> backGroundTextMap;
    private final HashMap<String, StaticText> stringStaticTextMap;
    private final HashMap<String, DescentText> descentTextMap;
    private final HashMap<String, DescentText> descentUnicodeMap;
    private final HashMap<String, ConditionalTexts> conditionalTextsMap;
    private final HashMap<String, VanillaHud> vanillaHudMap;
    private CustomNameplates plugin;

    public PlaceholderManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.nameplatePlaceholders = new NameplatePlaceholders(plugin, this);
        this.descent_fonts = new HashSet();
        this.descent_unicode_fonts = new HashSet();
        this.nameplateTextMap = new HashMap();
        this.backGroundTextMap = new HashMap();
        this.stringStaticTextMap = new HashMap();
        this.descentTextMap = new HashMap();
        this.conditionalTextsMap = new HashMap();
        this.vanillaHudMap = new HashMap();
        this.descentUnicodeMap = new HashMap();
    }

    @Override
    public void load() {
        this.nameplatePlaceholders.register();
        this.loadConfig();
    }

    @Override
    public void unload() {
        this.nameplatePlaceholders.unregister();
        this.descent_fonts.clear();
        this.nameplateTextMap.clear();
        this.backGroundTextMap.clear();
        this.stringStaticTextMap.clear();
        this.descentTextMap.clear();
        this.conditionalTextsMap.clear();
        this.vanillaHudMap.clear();
        this.descent_unicode_fonts.clear();
        this.descentUnicodeMap.clear();
    }

    private void loadConfig() {
        ConfigurationSection vanillaHudSection;
        ConfigurationSection conditionalSection;
        ConfigurationSection descentSection;
        ConfigurationSection staticTextSection;
        ConfigurationSection backgroundSection;
        YamlConfiguration config = ConfigUtils.getConfig("configs" + File.separator + "custom-placeholders.yml");
        ConfigurationSection nameplateSection = config.getConfigurationSection("nameplate-text");
        if (nameplateSection != null && ConfigManager.enableNameplates) {
            this.loadNameplateText(nameplateSection);
        }
        if ((backgroundSection = config.getConfigurationSection("background-text")) != null && ConfigManager.enableBackground) {
            this.loadBackgroundText(backgroundSection);
        }
        if ((staticTextSection = config.getConfigurationSection("static-text")) != null) {
            this.loadStaticText(staticTextSection);
        }
        if ((descentSection = config.getConfigurationSection("descent-text")) != null) {
            this.loadDescentText(descentSection);
        }
        if ((conditionalSection = config.getConfigurationSection("conditional-text")) != null) {
            this.loadConditionalText(conditionalSection);
        }
        if ((vanillaHudSection = config.getConfigurationSection("vanilla-hud")) != null) {
            this.loadVanillaHud(vanillaHudSection);
        }
        if (this.plugin.getVersionHelper().isVersionNewerThan1_20() && !ConfigManager.enable1_20_Unicode) {
            return;
        }
        ConfigurationSection descentUnicodeSection = config.getConfigurationSection("descent-unicode");
        if (descentUnicodeSection != null) {
            this.loadDescentUnicode(descentUnicodeSection);
        }
    }

    private void loadVanillaHud(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            this.vanillaHudMap.put(key, new VanillaHud(PlaceholderAPI.setPlaceholders(null, (String)section.getString(key + ".images.empty", "")) + ConfigManager.surroundWithFont(String.valueOf(OffsetFont.NEG_2.getCharacter())), PlaceholderAPI.setPlaceholders(null, (String)section.getString(key + ".images.half", "")) + ConfigManager.surroundWithFont(String.valueOf(OffsetFont.NEG_2.getCharacter())), PlaceholderAPI.setPlaceholders(null, (String)section.getString(key + ".images.full", "")) + ConfigManager.surroundWithFont(String.valueOf(OffsetFont.NEG_2.getCharacter())), section.getString(key + ".placeholder.value"), section.getString(key + ".placeholder.max-value"), section.getBoolean(key + ".reverse", true)));
        }
    }

    private void loadConditionalText(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            ConfigurationSection innerSection = section.getConfigurationSection(key);
            if (innerSection == null) continue;
            ArrayList<ConditionalText> conditionalTexts = new ArrayList<ConditionalText>();
            for (String priority : innerSection.getKeys(false)) {
                ConditionalText conditionalText = new ConditionalText(ConfigUtils.getRequirements(innerSection.getConfigurationSection(priority + ".conditions")), innerSection.getString(priority + ".text"), null);
                conditionalTexts.add(conditionalText);
            }
            this.conditionalTextsMap.put(key, new ConditionalTexts(conditionalTexts.toArray(new ConditionalText[0])));
        }
    }

    private void loadDescentText(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            this.descent_fonts.add(8 - section.getInt(key + ".descent"));
            this.descentTextMap.put(key, new DescentText(section.getString(key + ".text"), 8 - section.getInt(key + ".descent")));
        }
    }

    private void loadDescentUnicode(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            this.descent_unicode_fonts.add(8 - section.getInt(key + ".descent"));
            this.descentUnicodeMap.put(key, new DescentText(section.getString(key + ".text"), 8 - section.getInt(key + ".descent")));
        }
    }

    private void loadStaticText(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            this.stringStaticTextMap.put(key, new StaticText(section.getString(key + ".text"), section.getInt(key + ".value"), StaticText.StaticState.valueOf(section.getString(key + ".position", "left").toUpperCase(Locale.ENGLISH))));
        }
    }

    private void loadNameplateText(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            this.nameplateTextMap.put(key, new NameplateText(section.getString(key + ".text"), section.getString(key + ".nameplate")));
        }
    }

    private void loadBackgroundText(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            this.backGroundTextMap.put(key, new BackGroundText(section.getString(key + ".text"), section.getString(key + ".background"), section.getBoolean(key + ".remove-shadow", true)));
        }
    }

    public List<String> detectPlaceholders(String text) {
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher matcher = this.placeholderPattern.matcher(text);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    public ConditionalTexts getConditionalTexts(String key) {
        return this.conditionalTextsMap.get(key);
    }

    public BackGroundText getBackgroundText(String key) {
        return this.backGroundTextMap.get(key);
    }

    public NameplateText getNameplateText(String key) {
        return this.nameplateTextMap.get(key);
    }

    public StaticText getStaticText(String key) {
        return this.stringStaticTextMap.get(key);
    }

    public DescentText getDescentText(String key) {
        return this.descentTextMap.get(key);
    }

    public VanillaHud getVanillaHud(String key) {
        return this.vanillaHudMap.get(key);
    }

    public HashSet<Integer> getDescent_fonts() {
        return this.descent_fonts;
    }

    public HashSet<Integer> getDescent_unicode_fonts() {
        return this.descent_unicode_fonts;
    }

    public DescentText getDescentUnicode(String key) {
        return this.descentUnicodeMap.get(key);
    }
}

