/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.listener.JoinQuitListener;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.nameplate.NameplatesTeam;
import net.momirealms.customnameplates.object.team.TeamNameInterface;
import net.momirealms.customnameplates.object.team.TeamPacketInterface;
import net.momirealms.customnameplates.object.team.name.PlayerNameTeamImpl;
import net.momirealms.customnameplates.object.team.name.TABBungeeCordImpl;
import net.momirealms.customnameplates.object.team.name.TABImpl;
import net.momirealms.customnameplates.object.team.name.VelocitabImpl;
import net.momirealms.customnameplates.object.team.packet.TeamInfoImpl;
import net.momirealms.customnameplates.object.team.packet.TeamVisibilityImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class TeamManager
extends Function {
    private final ConcurrentHashMap<UUID, NameplatesTeam> teams;
    private TeamPacketInterface teamPacketInterface;
    private TeamNameInterface teamNameInterface;
    private final JoinQuitListener joinQuitListener;
    private final CustomNameplates plugin;
    private final ConcurrentHashMap<UUID, Integer> triedTimes;

    public TeamManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.teams = new ConcurrentHashMap();
        this.joinQuitListener = new JoinQuitListener(this);
        this.triedTimes = new ConcurrentHashMap();
    }

    @Override
    public void load() {
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
        this.teamNameInterface = ConfigManager.tab_BC_hook ? new TABBungeeCordImpl() : (ConfigManager.tab_hook ? new TABImpl() : (ConfigManager.velocitab_hook ? new VelocitabImpl() : new PlayerNameTeamImpl(this)));
        this.teamNameInterface.load();
    }

    @Override
    public void unload() {
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
        if (this.teamNameInterface != null) {
            this.teamNameInterface.unload();
        }
        this.teamPacketInterface = null;
    }

    @Override
    public void onQuit(Player player) {
        this.removePlayerFromTeamCache(player);
        this.teamNameInterface.onQuit(player);
        this.triedTimes.remove(player.getUniqueId());
    }

    public void setTeamPacketInterface() {
        if (this.plugin.getNameplateManager().getMode() == DisplayMode.TEAM) {
            this.teamPacketInterface = new TeamInfoImpl(this);
        } else if (this.plugin.getNameplateManager().getMode() == DisplayMode.ARMOR_STAND || this.plugin.getNameplateManager().getMode() == DisplayMode.TEXT_DISPLAY) {
            this.teamPacketInterface = new TeamVisibilityImpl(this);
        }
    }

    public void sendUpdateToOne(Player player) {
        if (this.teamPacketInterface != null) {
            this.teamPacketInterface.sendUpdateToOne(player);
        }
    }

    public void sendUpdateToAll(Player player, boolean force) {
        if (this.teamPacketInterface != null) {
            this.teamPacketInterface.sendUpdateToAll(player, force);
        }
    }

    public void createTeam(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || !player.isOnline() || !this.checkTriedTimes(player.getUniqueId())) {
            return;
        }
        String teamName = this.getCurrentTeamName(player);
        if (teamName != null) {
            if (!this.teams.containsKey(uuid)) {
                this.teams.put(uuid, new NameplatesTeam(this.plugin.getNameplateManager(), player, teamName));
            }
            this.teamPacketInterface.sendUpdateToAll(player, true);
            this.teamPacketInterface.sendUpdateToOne(player);
        } else {
            this.plugin.getScheduler().runTaskAsyncLater(() -> this.createTeam(uuid), 10L);
        }
    }

    @Nullable
    public NameplatesTeam getNameplateTeam(UUID uuid) {
        return this.teams.get(uuid);
    }

    public String getCurrentTeamName(Player player) {
        return this.teamNameInterface.getTeamName(player);
    }

    public void removePlayerFromTeamCache(Player player) {
        this.teams.remove(player.getUniqueId());
    }

    public boolean isFakeTeam() {
        return this.plugin.getNameplateManager().isFakeTeam();
    }

    protected boolean checkTriedTimes(UUID uuid) {
        Integer previous = this.triedTimes.get(uuid);
        if (previous == null) {
            this.triedTimes.put(uuid, 1);
            return true;
        }
        if (previous > 4) {
            this.triedTimes.remove(uuid);
            return false;
        }
        this.triedTimes.put(uuid, previous + 1);
        return true;
    }

    public TeamNameInterface getTeamNameInterface() {
        return this.teamNameInterface;
    }
}

