/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object;

import java.util.ArrayList;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.Component;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.entity.Player;

public class DynamicText {
    private final Player owner;
    private String originalValue;
    private String latestValue;
    private String[] ownerPlaceholders;

    public DynamicText(Player owner, String rawValue) {
        this.owner = owner;
        this.analyze(rawValue);
    }

    private void analyze(String value) {
        ArrayList<String> placeholdersOwner = new ArrayList<String>(CustomNameplates.getInstance().getPlaceholderManager().detectPlaceholders(value));
        String origin = value;
        for (String placeholder : placeholdersOwner) {
            origin = origin.replace(placeholder, "%s");
        }
        this.originalValue = origin;
        this.ownerPlaceholders = placeholdersOwner.toArray(new String[0]);
        this.latestValue = this.originalValue;
        this.update();
    }

    public String getLatestValue() {
        return this.latestValue;
    }

    public String getLatestJson() {
        return (String)GsonComponentSerializer.gson().serialize(this.getLatestComponent());
    }

    public Component getLatestComponent() {
        return AdventureUtils.getComponentFromMiniMessage(this.latestValue);
    }

    public boolean update() {
        String string;
        if (this.ownerPlaceholders.length == 0) {
            return false;
        }
        if ("%s".equals(this.originalValue)) {
            string = PlaceholderAPI.setPlaceholders((Player)this.owner, (String)this.ownerPlaceholders[0]);
        } else {
            Object[] values = new String[this.ownerPlaceholders.length];
            for (int i = 0; i < this.ownerPlaceholders.length; ++i) {
                values[i] = PlaceholderAPI.setPlaceholders((Player)this.owner, (String)this.ownerPlaceholders[i]);
            }
            string = String.format(this.originalValue, values);
        }
        if (!this.latestValue.equals(string)) {
            this.latestValue = string;
            return true;
        }
        return false;
    }
}

