/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.carrier;

import com.comphenix.protocol.events.PacketEvent;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.object.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class AbstractPacketsHandler
extends Function {
    protected ConcurrentHashMap<Integer, Player> entityIdMap = new ConcurrentHashMap();

    @Override
    public void load() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.entityIdMap.put(player.getEntityId(), player);
        }
    }

    @Override
    public void unload() {
        this.entityIdMap.clear();
    }

    @Override
    public void onJoin(Player player) {
        this.entityIdMap.put(player.getEntityId(), player);
    }

    @Override
    public void onQuit(Player player) {
        this.entityIdMap.remove(player.getEntityId());
    }

    public void onEntityMove(Player receiver, int entityId, short x, short y, short z, boolean onGround) {
    }

    public void onEntitySpawn(Player receiver, int entityId, PacketEvent event) {
    }

    public void onEntityDestroy(Player receiver, List<Integer> entities) {
    }

    public void onEntityDestroy(Player receiver, int entity) {
    }

    public void onEntityTeleport(Player player, int entityId) {
    }

    public Player getPlayerFromMap(int entityID) {
        return this.entityIdMap.get(entityID);
    }
}

