/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.carrier;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.DynamicText;
import net.momirealms.customnameplates.object.carrier.NamedEntity;
import net.momirealms.customnameplates.object.carrier.NamedEntityManager;
import net.momirealms.customnameplates.object.carrier.TextDisplayMeta;
import net.momirealms.customnameplates.object.requirements.Requirement;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedEntityImpl
implements NamedEntity {
    private final NamedEntityManager nem;
    private final Player owner;
    private double yOffset;
    private final int entityId;
    private final UUID uuid = UUID.randomUUID();
    private boolean sneaking;
    private DynamicText dynamicText;
    private String textJson;
    private final Requirement[] requirements;
    private boolean isShown;
    private final TextDisplayMeta textDisplayMeta;

    public NamedEntityImpl(NamedEntityManager nem, Player owner, DynamicText text, double yOffset, @NotNull Requirement[] requirements, @Nullable TextDisplayMeta textDisplayMeta) {
        this.nem = nem;
        this.entityId = new Random().nextInt(Integer.MAX_VALUE);
        this.owner = owner;
        this.yOffset = yOffset;
        this.dynamicText = text;
        this.sneaking = owner.isSneaking();
        this.requirements = requirements;
        this.isShown = false;
        this.textJson = this.dynamicText.getLatestJson();
        this.textDisplayMeta = textDisplayMeta;
    }

    public NamedEntityImpl(NamedEntityManager nem, Player owner, String textJson, double yOffset, @Nullable TextDisplayMeta textDisplayMeta) {
        this.nem = nem;
        this.entityId = new Random().nextInt(Integer.MAX_VALUE);
        this.owner = owner;
        this.yOffset = yOffset;
        this.textJson = textJson;
        this.sneaking = owner.isSneaking();
        this.requirements = null;
        this.isShown = true;
        this.textDisplayMeta = textDisplayMeta;
    }

    @Override
    public boolean canShow() {
        if (this.owner.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return false;
        }
        if (this.requirements == null) {
            return true;
        }
        for (Requirement requirement : this.requirements) {
            if (requirement.isConditionMet(this.owner)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void refresh() {
        if (this.dynamicText == null) {
            return;
        }
        this.textJson = this.dynamicText.getLatestJson();
        this.updateMetadata();
    }

    @Override
    public double getOffset() {
        return this.yOffset;
    }

    @Override
    public void setOffset(double offset) {
        if (this.yOffset == offset) {
            return;
        }
        this.yOffset = offset;
        for (Player all : this.nem.getNearbyPlayers()) {
            CustomNameplates.getProtocolManager().sendServerPacket(all, this.getTeleportPacket());
        }
    }

    @Override
    public void spawn(Player viewer) {
        for (PacketContainer packet : this.getSpawnPackets()) {
            CustomNameplates.getProtocolManager().sendServerPacket(viewer, packet);
        }
    }

    @Override
    public void spawn() {
        for (Player all : this.nem.getNearbyPlayers()) {
            this.spawn(all);
        }
        this.isShown = true;
    }

    @Override
    public void destroy() {
        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        destroyPacket.getIntLists().write(0, List.of(Integer.valueOf(this.entityId)));
        for (Player all : this.nem.getNearbyPlayers()) {
            CustomNameplates.getProtocolManager().sendServerPacket(all, destroyPacket);
        }
        this.isShown = false;
    }

    @Override
    public void destroy(Player viewer) {
        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        destroyPacket.getIntLists().write(0, List.of(Integer.valueOf(this.entityId)));
        CustomNameplates.getProtocolManager().sendServerPacket(viewer, destroyPacket);
    }

    @Override
    public void teleport() {
        PacketContainer packet = this.getTeleportPacket();
        for (Player all : this.nem.getNearbyPlayers()) {
            CustomNameplates.getProtocolManager().sendServerPacket(all, packet);
        }
    }

    @Override
    public void teleport(Player viewer) {
        if (!this.nem.isNearby(viewer) && viewer != this.owner) {
            this.nem.spawn(viewer);
        } else {
            CustomNameplates.getProtocolManager().sendServerPacket(viewer, this.getTeleportPacket());
        }
    }

    @Override
    public void setSneak(boolean isSneaking, boolean respawn) {
        this.sneaking = isSneaking;
        if (respawn) {
            for (Player viewer : this.nem.getNearbyPlayers()) {
                this.respawn(viewer);
            }
        } else {
            this.refresh();
        }
    }

    @Override
    public boolean isShown() {
        return this.isShown;
    }

    @Override
    public DynamicText getDynamicText() {
        return this.dynamicText;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void move(Player viewer, short x, short y, short z, boolean onGround) {
        PacketContainer packet = this.getMovePacket(x, y, z, onGround);
        CustomNameplates.getProtocolManager().sendServerPacket(viewer, packet);
    }

    @Override
    public void respawn(Player viewer) {
        this.destroy(viewer);
        this.spawn(viewer);
    }

    public PacketContainer getMovePacket(short x, short y, short z, boolean onGround) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
        packet.getIntegers().write(0, (Object)this.entityId);
        packet.getShorts().write(0, (Object)x);
        packet.getShorts().write(1, (Object)y);
        packet.getShorts().write(2, (Object)z);
        packet.getBooleans().write(0, (Object)onGround);
        return packet;
    }

    public PacketContainer getTeleportPacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)this.entityId);
        Location location = this.getEntityLocation();
        packet.getDoubles().write(0, (Object)location.getX());
        packet.getDoubles().write(1, (Object)location.getY());
        packet.getDoubles().write(2, (Object)location.getZ());
        return packet;
    }

    public void updateMetadata() {
        PacketContainer metaPacket = this.getMetaPacket();
        for (Player viewer : this.nem.getNearbyPlayers()) {
            CustomNameplates.getProtocolManager().sendServerPacket(viewer, metaPacket);
        }
    }

    protected PacketContainer getMetaPacket() {
        PacketContainer metaPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
        metaPacket.getIntegers().write(0, (Object)this.entityId);
        if (CustomNameplates.getInstance().getVersionHelper().isVersionNewerThan1_19_R2()) {
            WrappedDataWatcher wrappedDataWatcher = this.nem.getDisplayMode() == DisplayMode.ARMOR_STAND ? this.createArmorStandDataWatcher(this.textJson) : this.createTextDisplayDataWatcher(this.textJson, this.textDisplayMeta);
            ArrayList wrappedDataValueList = Lists.newArrayList();
            wrappedDataWatcher.getWatchableObjects().stream().filter(Objects::nonNull).forEach(entry -> wrappedDataValueList.add(new WrappedDataValue(entry.getWatcherObject().getIndex(), entry.getWatcherObject().getSerializer(), entry.getRawValue())));
            metaPacket.getDataValueCollectionModifier().write(0, (Object)wrappedDataValueList);
        } else {
            metaPacket.getWatchableCollectionModifier().write(0, (Object)this.createArmorStandDataWatcher(this.textJson).getWatchableObjects());
        }
        return metaPacket;
    }

    private Location getEntityLocation() {
        double x = this.owner.getLocation().getX();
        double y = this.getY() + this.yOffset;
        double z = this.owner.getLocation().getZ();
        y = !this.owner.isSleeping() ? (this.sneaking ? (y += 1.5) : (y += 1.8)) : (y += 0.2);
        return new Location(null, x, y += this.nem.getHatOffset(), z);
    }

    private double getY() {
        Entity vehicle = this.owner.getVehicle();
        if (vehicle != null) {
            switch (vehicle.getType()) {
                case BOAT: 
                case CHEST_BOAT: {
                    return vehicle.getLocation().getY() - 0.325;
                }
                case HORSE: {
                    return vehicle.getLocation().getY() + 0.85;
                }
                case DONKEY: {
                    return vehicle.getLocation().getY() + 0.525;
                }
                case PIG: {
                    return vehicle.getLocation().getY() + 0.325;
                }
                case STRIDER: {
                    return vehicle.getLocation().getY() + 1.15;
                }
            }
        }
        if (this.owner.getPose() == Pose.SWIMMING || this.owner.isGliding()) {
            return this.owner.getLocation().getY() - 1.25;
        }
        return this.owner.getLocation().getY();
    }

    private WrappedDataWatcher createArmorStandDataWatcher(String json) {
        WrappedDataWatcher wrappedDataWatcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer1 = WrappedDataWatcher.Registry.get(Boolean.class);
        WrappedDataWatcher.Serializer serializer2 = WrappedDataWatcher.Registry.get(Byte.class);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true)), Optional.of(WrappedChatComponent.fromJson((String)json).getHandle()));
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, serializer1), (Object)true);
        byte flag = 32;
        if (this.sneaking) {
            flag = (byte)(flag + 2);
        }
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(0, serializer2), (Object)flag);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(15, serializer2), (Object)1);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, serializer1), (Object)true);
        return wrappedDataWatcher;
    }

    private WrappedDataWatcher createTextDisplayDataWatcher(String textJson, TextDisplayMeta textDisplayMeta) {
        WrappedDataWatcher wrappedDataWatcher = new WrappedDataWatcher();
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(22, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)false)), (Object)WrappedChatComponent.fromJson((String)textJson));
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(24, WrappedDataWatcher.Registry.get(Integer.class)), (Object)textDisplayMeta.backgroundColor());
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(14, WrappedDataWatcher.Registry.get(Byte.class)), (Object)3);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(25, WrappedDataWatcher.Registry.get(Byte.class)), (Object)textDisplayMeta.opacity());
        int mask = 0;
        if (textDisplayMeta.hasShadow()) {
            ++mask;
        }
        if (textDisplayMeta.isSeeThrough()) {
            mask += 2;
        }
        if (textDisplayMeta.useDefaultBackground()) {
            mask += 4;
        }
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(26, WrappedDataWatcher.Registry.get(Byte.class)), (Object)((byte)mask));
        return wrappedDataWatcher;
    }

    private PacketContainer[] getSpawnPackets() {
        PacketContainer entityPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        entityPacket.getModifier().write(0, (Object)this.entityId);
        entityPacket.getModifier().write(1, (Object)this.uuid);
        entityPacket.getEntityTypeModifier().write(0, (Object)(this.nem.getDisplayMode() == DisplayMode.ARMOR_STAND ? EntityType.ARMOR_STAND : EntityType.TEXT_DISPLAY));
        Location location = this.getEntityLocation();
        entityPacket.getDoubles().write(0, (Object)location.getX());
        entityPacket.getDoubles().write(1, (Object)location.getY());
        entityPacket.getDoubles().write(2, (Object)location.getZ());
        PacketContainer metaPacket = this.getMetaPacket();
        return new PacketContainer[]{entityPacket, metaPacket};
    }
}

