/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.carrier;

import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.carrier.NamedEntityCarrier;
import net.momirealms.customnameplates.object.scheduler.TimerTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class VehicleChecker
extends Function {
    private final ConcurrentHashMap<Player, Entity> playersOnVehicle;
    private final NamedEntityCarrier namedEntityCarrier;
    private TimerTask updatePosTask;
    private TimerTask vehicleCheckTask;

    public VehicleChecker(NamedEntityCarrier namedEntityCarrier) {
        this.namedEntityCarrier = namedEntityCarrier;
        this.playersOnVehicle = new ConcurrentHashMap();
    }

    @Override
    public void load() {
        for (Player all : Bukkit.getOnlinePlayers()) {
            Entity vehicle = all.getVehicle();
            if (vehicle == null) continue;
            this.playersOnVehicle.put(all, vehicle);
        }
        this.updatePosTask = CustomNameplates.getInstance().getScheduler().runTaskAsyncTimer(() -> {
            for (Player inVehicle : this.playersOnVehicle.keySet()) {
                if (!inVehicle.isOnline() || this.namedEntityCarrier.getNamedEntityManager(inVehicle) == null) continue;
                this.namedEntityCarrier.getNamedEntityManager(inVehicle).teleport();
            }
        }, 1L, 1L);
        this.vehicleCheckTask = CustomNameplates.getInstance().getScheduler().runTaskAsyncTimer(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.refresh(player);
            }
        }, 4L, 4L);
    }

    @Override
    public void unload() {
        this.updatePosTask.cancel();
        this.vehicleCheckTask.cancel();
        this.playersOnVehicle.clear();
    }

    @Override
    public void onJoin(Player player) {
        Entity vehicle = player.getVehicle();
        if (vehicle != null) {
            this.playersOnVehicle.put(player, vehicle);
        }
    }

    @Override
    public void onQuit(Player player) {
        this.playersOnVehicle.remove(player);
    }

    public void refresh(Player player) {
        Entity vehicle = player.getVehicle();
        if (this.playersOnVehicle.containsKey(player) && vehicle == null) {
            this.namedEntityCarrier.getNamedEntityManager(player).teleport();
            this.playersOnVehicle.remove(player);
        }
        if (!this.playersOnVehicle.containsKey(player) && vehicle != null) {
            this.namedEntityCarrier.getNamedEntityManager(player).respawn();
            this.playersOnVehicle.put(player, vehicle);
        }
    }
}

