/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.placeholders;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.manager.FontManager;
import net.momirealms.customnameplates.manager.NameplateManager;
import net.momirealms.customnameplates.manager.PlaceholderManager;
import net.momirealms.customnameplates.object.SimpleChar;
import net.momirealms.customnameplates.object.nameplate.NameplateConfig;
import net.momirealms.customnameplates.object.nameplate.NameplatesTeam;
import net.momirealms.customnameplates.object.placeholders.BackGroundText;
import net.momirealms.customnameplates.object.placeholders.ConditionalTexts;
import net.momirealms.customnameplates.object.placeholders.DescentText;
import net.momirealms.customnameplates.object.placeholders.NameplateText;
import net.momirealms.customnameplates.object.placeholders.StaticText;
import net.momirealms.customnameplates.object.placeholders.VanillaHud;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class NameplatePlaceholders
extends PlaceholderExpansion {
    private final PlaceholderManager placeholderManager;
    private final CustomNameplates plugin;

    public NameplatePlaceholders(CustomNameplates plugin, PlaceholderManager placeholderManager) {
        this.placeholderManager = placeholderManager;
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "nameplates";
    }

    @NotNull
    public String getAuthor() {
        return "XiaoMoMi";
    }

    @NotNull
    public String getVersion() {
        return "2.2";
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String params) {
        String[] mainParam = params.split("_", 2);
        switch (mainParam[0]) {
            case "prefix": {
                return this.getPrefix(player);
            }
            case "suffix": {
                return this.getSuffix(player);
            }
            case "equipped": {
                return this.getEquipped(mainParam[1], player);
            }
            case "static": {
                return this.getStatic(mainParam[1], player);
            }
            case "background": {
                return this.getBackground(mainParam[1], player);
            }
            case "nameplate": {
                return this.getNameplateText(mainParam[1], player);
            }
            case "conditional": {
                return this.getConditional(mainParam[1], player);
            }
            case "descent": {
                return this.getDescent(mainParam[1], player);
            }
            case "vanilla": {
                return this.getVanilla(mainParam[1], player);
            }
            case "image": {
                return this.getImage(mainParam[1]);
            }
            case "offset": {
                return this.getOffset(mainParam[1]);
            }
            case "time": {
                return this.getTime(player);
            }
            case "checkupdate": {
                return String.valueOf(!this.plugin.getVersionHelper().isLatest());
            }
            case "actionbar": {
                return this.getOtherActionBar(player);
            }
            case "unicode": {
                return this.getUnicodeDescent(mainParam[1], player);
            }
        }
        return null;
    }

    private String getOtherActionBar(Player player) {
        return this.plugin.getActionBarManager().getOtherPluginActionBarText(player);
    }

    private String getOffset(String s) {
        return ConfigManager.surroundWithFont(this.plugin.getFontManager().getOffset(Integer.parseInt(s)));
    }

    private String getNameplateText(String param, Player player) {
        NameplateText nameplateText = this.placeholderManager.getNameplateText(param);
        if (nameplateText == null) {
            return param + " NOT FOUND";
        }
        String parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)nameplateText.text());
        NameplateManager nameplateManager = this.plugin.getNameplateManager();
        NameplateConfig nameplateConfig = nameplateManager.getNameplateConfig(nameplateText.nameplate());
        if (nameplateConfig == null) {
            return nameplateText.nameplate() + " NOT FOUND";
        }
        String text = AdventureUtils.stripAllTags(parsed);
        return nameplateManager.getNameplatePrefixWithFont(text, nameplateConfig) + parsed + this.plugin.getFontManager().getSuffixStringWithFont(text);
    }

    private String getEquipped(String param, Player player) {
        if (param.equals("nameplate")) {
            return this.plugin.getDataManager().getEquippedNameplate(player);
        }
        if (param.equals("bubble")) {
            return this.plugin.getDataManager().getEquippedBubble(player);
        }
        return "null";
    }

    private String getTime(Player player) {
        long time = player.getWorld().getTime();
        String ap = time >= 6000L && time < 18000L ? " PM" : " AM";
        int hours = (int)(time / 1000L);
        int minutes = (int)((double)(time - (long)(hours * 1000)) * 0.06);
        hours += 6;
        while (hours >= 12) {
            hours -= 12;
        }
        if (minutes < 10) {
            return hours + ":0" + minutes + ap;
        }
        return hours + ":" + minutes + ap;
    }

    private String getImage(String param) {
        SimpleChar simpleChar = this.plugin.getImageManager().getImage(param);
        if (simpleChar == null) {
            return param + " NOT FOUND";
        }
        return ConfigManager.surroundWithFont(String.valueOf(simpleChar.getChars()));
    }

    private String getPrefix(Player player) {
        NameplatesTeam nameplatesTeam = this.plugin.getTeamManager().getNameplateTeam(player.getUniqueId());
        if (nameplatesTeam != null) {
            return nameplatesTeam.getNameplatePrefixText();
        }
        return "";
    }

    private String getSuffix(Player player) {
        NameplatesTeam nameplatesTeam = this.plugin.getTeamManager().getNameplateTeam(player.getUniqueId());
        if (nameplatesTeam != null) {
            return nameplatesTeam.getNameplateSuffixText();
        }
        return "";
    }

    private String getStatic(String param, Player player) {
        StaticText staticText = this.placeholderManager.getStaticText(param);
        if (staticText == null) {
            return param + " NOT FOUND";
        }
        FontManager fontManager = this.plugin.getFontManager();
        String parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)staticText.text());
        int parsedWidth = fontManager.getTotalWidth(AdventureUtils.stripAllTags(parsed));
        if (staticText.staticState() == StaticText.StaticState.LEFT) {
            return parsed + ConfigManager.surroundWithFont(fontManager.getOffset(staticText.value() - parsedWidth));
        }
        if (staticText.staticState() == StaticText.StaticState.RIGHT) {
            return ConfigManager.surroundWithFont(fontManager.getOffset(staticText.value() - parsedWidth)) + parsed;
        }
        if (staticText.staticState() == StaticText.StaticState.MIDDLE) {
            int half = (staticText.value() - parsedWidth) / 2;
            String left = ConfigManager.surroundWithFont(fontManager.getOffset(half));
            String right = ConfigManager.surroundWithFont(fontManager.getOffset(staticText.value() - parsedWidth - half));
            return left + parsed + right;
        }
        return "";
    }

    private String getBackground(String param, Player player) {
        BackGroundText backGroundText = this.placeholderManager.getBackgroundText(param);
        if (backGroundText == null) {
            return param + " NOT FOUND";
        }
        String parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)backGroundText.text());
        Object background = this.plugin.getBackgroundManager().getBackGroundImage(backGroundText, AdventureUtils.stripAllTags(parsed));
        if (backGroundText.remove_shadow()) {
            background = "<#FFFEFD>" + (String)background + "</#FFFEFD>";
        }
        return ConfigManager.surroundWithFont((String)background) + parsed;
    }

    private String getConditional(String param, Player player) {
        ConditionalTexts conditionalTexts = this.placeholderManager.getConditionalTexts(param);
        if (conditionalTexts == null) {
            return param + " NOT FOUND";
        }
        String value = conditionalTexts.getValue(player);
        return PlaceholderAPI.setPlaceholders((Player)player, (String)value);
    }

    private String getDescent(String param, Player player) {
        DescentText descentText = this.placeholderManager.getDescentText(param);
        if (descentText == null) {
            return param + " NOT FOUND";
        }
        String parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)descentText.text());
        return "<font:" + ConfigManager.namespace + ":ascent_" + descentText.ascent() + ">" + parsed + "</font>";
    }

    private String getUnicodeDescent(String param, Player player) {
        if (!ConfigManager.enable1_20_Unicode && this.plugin.getVersionHelper().isVersionNewerThan1_20()) {
            return "Not Available on 1.20";
        }
        DescentText descentText = this.placeholderManager.getDescentUnicode(param);
        if (descentText == null) {
            return param + " NOT FOUND";
        }
        String parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)descentText.text());
        return "<font:" + ConfigManager.namespace + ":unicode_ascent_" + descentText.ascent() + ">" + parsed + "</font>";
    }

    private String getVanilla(String param, Player player) {
        double max;
        double current;
        VanillaHud vanillaHud = this.placeholderManager.getVanillaHud(param);
        if (vanillaHud == null) {
            return param + " NOT FOUND";
        }
        try {
            current = Double.parseDouble(PlaceholderAPI.setPlaceholders((Player)player, (String)vanillaHud.papi()));
            max = Double.parseDouble(PlaceholderAPI.setPlaceholders((Player)player, (String)vanillaHud.max()));
        }
        catch (NumberFormatException e) {
            current = 1.0;
            max = 1.0;
        }
        if (current >= max) {
            current = max;
        }
        if (current < 0.0) {
            current = 0.0;
        }
        int point = (int)(current / max * 20.0);
        int full_amount = point / 2;
        int half_amount = point % 2;
        int empty_amount = 10 - full_amount - half_amount;
        if (vanillaHud.reverse()) {
            return "<#FFFEFD>" + vanillaHud.empty().repeat(empty_amount) + vanillaHud.half().repeat(half_amount) + vanillaHud.full().repeat(full_amount) + "</#FFFEFD>";
        }
        return "<#FFFEFD>" + vanillaHud.full().repeat(full_amount) + vanillaHud.half().repeat(half_amount) + vanillaHud.empty().repeat(empty_amount) + "</#FFFEFD>";
    }
}

