/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.requirements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.customnameplates.object.requirements.Requirement;
import net.momirealms.customnameplates.object.requirements.papi.ExpressionAnd;
import net.momirealms.customnameplates.object.requirements.papi.ExpressionOr;
import net.momirealms.customnameplates.object.requirements.papi.PapiEquals;
import net.momirealms.customnameplates.object.requirements.papi.PapiGreater;
import net.momirealms.customnameplates.object.requirements.papi.PapiNoLarger;
import net.momirealms.customnameplates.object.requirements.papi.PapiNoLess;
import net.momirealms.customnameplates.object.requirements.papi.PapiNotEquals;
import net.momirealms.customnameplates.object.requirements.papi.PapiRegex;
import net.momirealms.customnameplates.object.requirements.papi.PapiRequirement;
import net.momirealms.customnameplates.object.requirements.papi.PapiSmaller;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;

public class CustomPapiImpl
implements Requirement {
    private final List<PapiRequirement> papiRequirement;

    public CustomPapiImpl(Map<String, Object> expressions) {
        this.papiRequirement = this.getRequirements(expressions);
    }

    @Override
    public boolean isConditionMet(Player player) {
        for (PapiRequirement requirement : this.papiRequirement) {
            if (requirement.isMet(player)) continue;
            return false;
        }
        return true;
    }

    private List<PapiRequirement> getRequirements(Map<String, Object> map) {
        ArrayList<PapiRequirement> papiRequirements = new ArrayList<PapiRequirement>();
        map.keySet().forEach(key -> {
            if (key.startsWith("&&")) {
                Object patt1766$temp = map.get(key);
                if (patt1766$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt1766$temp;
                    papiRequirements.add(new ExpressionAnd(this.getRequirements(map2.getValues(false))));
                }
            } else if (key.startsWith("||")) {
                Object patt2002$temp = map.get(key);
                if (patt2002$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt2002$temp;
                    papiRequirements.add(new ExpressionOr(this.getRequirements(map2.getValues(false))));
                }
            } else {
                Object patt2211$temp = map.get(key);
                if (patt2211$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt2211$temp;
                    String type = map2.getString("type");
                    String papi = map2.getString("papi");
                    String value = map2.getString("value");
                    if (value == null || papi == null || type == null) {
                        return;
                    }
                    switch (type) {
                        case "==": {
                            papiRequirements.add(new PapiEquals(papi, value));
                            break;
                        }
                        case "!=": {
                            papiRequirements.add(new PapiNotEquals(papi, value));
                            break;
                        }
                        case ">=": {
                            papiRequirements.add(new PapiNoLess(papi, value));
                            break;
                        }
                        case "<=": {
                            papiRequirements.add(new PapiNoLarger(papi, value));
                            break;
                        }
                        case "<": {
                            papiRequirements.add(new PapiSmaller(papi, value));
                            break;
                        }
                        case ">": {
                            papiRequirements.add(new PapiGreater(papi, value));
                            break;
                        }
                        case "regex": {
                            papiRequirements.add(new PapiRegex(papi, value));
                        }
                    }
                }
            }
        });
        return papiRequirements;
    }
}

