/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.team.name;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.util.Collections;
import java.util.Optional;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.manager.TeamManager;
import net.momirealms.customnameplates.object.team.TeamNameInterface;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class PlayerNameTeamImpl
implements TeamNameInterface {
    private final TeamManager teamManager;

    public PlayerNameTeamImpl(TeamManager teamManager) {
        this.teamManager = teamManager;
    }

    @Override
    public String getTeamName(Player player) {
        return player.getName();
    }

    @Override
    public void onJoin(Player player) {
        if (this.teamManager.isFakeTeam()) {
            this.createFakeTeamToAll(player);
        } else {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            Team team = scoreboard.getTeam(player.getName());
            if (team == null) {
                team = scoreboard.registerNewTeam(player.getName());
            }
            team.addEntry(player.getName());
        }
    }

    @Override
    public void onQuit(Player player) {
        if (this.teamManager.isFakeTeam()) {
            this.destroyTeamToAll(player);
        } else {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            Team team = scoreboard.getTeam(player.getName());
            if (team != null) {
                team.unregister();
            }
        }
    }

    @Override
    public void unload() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.onQuit(player);
        }
    }

    @Override
    public void load() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.onJoin(player);
        }
    }

    public void createFakeTeamToAll(Player joinPlayer) {
        PacketContainer packetToAll = this.getPlayerTeamCreatePacket(joinPlayer);
        for (Player all : Bukkit.getOnlinePlayers()) {
            CustomNameplates.getProtocolManager().sendServerPacket(joinPlayer, this.getPlayerTeamCreatePacket(all));
            if (joinPlayer == all) continue;
            CustomNameplates.getProtocolManager().sendServerPacket(all, packetToAll);
        }
    }

    private PacketContainer getPlayerTeamCreatePacket(Player joinPlayer) {
        PacketContainer packetToAll = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
        packetToAll.getIntegers().write(0, (Object)0);
        packetToAll.getStrings().write(0, (Object)joinPlayer.getName());
        packetToAll.getModifier().write(2, Collections.singletonList(joinPlayer.getName()));
        Optional optionalInternalStructure = (Optional)packetToAll.getOptionalStructures().read(0);
        if (optionalInternalStructure.isPresent()) {
            InternalStructure internalStructure = (InternalStructure)optionalInternalStructure.get();
            internalStructure.getEnumModifier(ChatColor.class, MinecraftReflection.getMinecraftClass((String)"EnumChatFormat")).write(0, (Object)ChatColor.WHITE);
        }
        return packetToAll;
    }

    public void destroyTeamToAll(Player quitPlayer) {
        PacketContainer packetToAll = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
        packetToAll.getIntegers().write(0, (Object)1);
        packetToAll.getStrings().write(0, (Object)quitPlayer.getName());
        for (Player all : Bukkit.getOnlinePlayers()) {
            CustomNameplates.getProtocolManager().sendServerPacket(all, packetToAll);
        }
    }
}

