/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.team.name;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.object.team.TeamNameInterface;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class VelocitabImpl
implements TeamNameInterface {
    private final ConcurrentHashMap<String, String> teamNameMap = new ConcurrentHashMap();
    private final ProxyDataListener proxyDataListener = new ProxyDataListener(this);

    @Override
    public void load() {
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)CustomNameplates.getInstance(), "customnameplates:cnp");
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)CustomNameplates.getInstance(), "customnameplates:cnp", (PluginMessageListener)this.proxyDataListener);
    }

    @Override
    public void unload() {
        this.teamNameMap.clear();
        Bukkit.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)CustomNameplates.getInstance(), "customnameplates:cnp");
        Bukkit.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)CustomNameplates.getInstance(), "customnameplates:cnp");
    }

    @Override
    public String getTeamName(Player player) {
        String teamName = this.teamNameMap.get(player.getName());
        if (teamName == null) {
            this.sendRequest(player);
            return null;
        }
        return teamName;
    }

    @Override
    public void onJoin(Player player) {
        this.sendRequest(player);
    }

    @Override
    public void onQuit(Player player) {
        this.teamNameMap.remove(player.getName());
    }

    private void sendRequest(Player player) {
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        dataOutput.writeUTF(player.getName());
        player.sendPluginMessage((Plugin)CustomNameplates.getInstance(), "customnameplates:cnp", dataOutput.toByteArray());
    }

    public void addPlayerToCache(String playerName, String teamName) {
        this.teamNameMap.put(playerName, teamName);
    }

    public static class ProxyDataListener
    implements PluginMessageListener {
        private final VelocitabImpl TABBungeeCordImpl;

        public ProxyDataListener(VelocitabImpl TABBungeeCordImpl2) {
            this.TABBungeeCordImpl = TABBungeeCordImpl2;
        }

        public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
            if (!Objects.equals("customnameplates:cnp", channel)) {
                return;
            }
            ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])message);
            String playerName = dataInput.readUTF();
            String teamName = dataInput.readUTF();
            this.TABBungeeCordImpl.addPlayerToCache(playerName, teamName);
        }
    }
}

