/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api;

import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.bossbar.BossBarHandler;
import com.ehhthan.happyhud.api.element.layout.HudLayout;
import com.ehhthan.happyhud.api.element.popup.HudPopup;
import com.ehhthan.happyhud.api.hud.active.element.AbstractActiveElementHolder;
import com.ehhthan.happyhud.api.hud.active.element.ActiveLayout;
import com.ehhthan.happyhud.api.hud.active.element.ActivePopup;
import com.ehhthan.happyhud.api.hud.layer.listener.InternalListener;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.happyhud.api.tag.HudTag;
import com.ehhthan.happyhud.manager.LayoutManager;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.TextComponent;
import com.ehhthan.libraries.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class HudHolder
implements PersistentDataHolder {
    @NotNull
    private static final NamespacedKey LAYOUTS_KEY = NamespacedKey.fromString((String)"hud_layouts", (Plugin)HappyHUD.getInstance());
    @NotNull
    private static final NamespacedKey ENABLE_KEY = NamespacedKey.fromString((String)"enable", (Plugin)HappyHUD.getInstance());
    private static final Map<Player, HudHolder> DATA = new HashMap<Player, HudHolder>();
    private final Player player;
    private final BossBarHandler barHandler;
    private boolean updating;
    private BukkitTask placeholderTask;
    private final Map<String, ActiveLayout> layouts = new LinkedHashMap<String, ActiveLayout>();
    private final Map<String, ActivePopup> popups = new LinkedHashMap<String, ActivePopup>();

    private HudHolder(@NotNull Player player) {
        this.player = player;
        this.barHandler = new BossBarHandler(this);
    }

    private void initialize() {
        this.barHandler.init();
        this.reloadLayouts();
        this.send();
        this.placeholderTask = Bukkit.getScheduler().runTaskTimer((Plugin)HappyHUD.getInstance(), () -> {
            this.update(InternalListener.REOCCURRING);
            this.update(HappyHUD.getInstance().listeners().getPlaceholderListeners());
        }, 1L, (long)HappyHUD.getInstance().getConfig().getInt("check-update", 5));
    }

    public void disable() {
        this.getPersistentDataContainer().set(ENABLE_KEY, HudTag.BOOLEAN, (Object)false);
        this.barHandler.disable();
        this.remove();
    }

    public void remove() {
        if (this.placeholderTask != null) {
            this.placeholderTask.cancel();
        }
        DATA.remove(this.player);
    }

    public void reloadLayouts() {
        PersistentDataContainer persistentDataContainer;
        this.layouts.clear();
        LayoutManager layoutManager = HappyHUD.getInstance().layouts();
        if (!this.getPersistentDataContainer().has(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER)) {
            this.getPersistentDataContainer().set(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER, (Object)this.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer());
        }
        if ((persistentDataContainer = (PersistentDataContainer)this.getPersistentDataContainer().get(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER)) != null) {
            Object object;
            for (HudLayout hudLayout : layoutManager.getDefaults()) {
                object = new NamespacedKey((Plugin)HappyHUD.getInstance(), hudLayout.getKey());
                if (persistentDataContainer.has(object, HudTag.BOOLEAN)) continue;
                persistentDataContainer.set(object, HudTag.BOOLEAN, (Object)true);
            }
            this.getPersistentDataContainer().set(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER, (Object)persistentDataContainer);
            for (HudLayout hudLayout : persistentDataContainer.getKeys()) {
                object = hudLayout.getKey();
                Boolean bl = (Boolean)persistentDataContainer.get((NamespacedKey)hudLayout, HudTag.BOOLEAN);
                if (bl == null || !bl.booleanValue() || !layoutManager.has((String)object)) continue;
                HudLayout hudLayout2 = layoutManager.get((String)object);
                this.layouts.put(hudLayout2.getKey(), new ActiveLayout(this, hudLayout2));
            }
        }
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    public BossBarHandler getBarHandler() {
        return this.barHandler;
    }

    public void update(LayerListener ... layerListenerArray) {
        boolean bl = false;
        for (ActiveLayout abstractActiveElementHolder : this.layouts.values()) {
            if (!abstractActiveElementHolder.update(layerListenerArray)) continue;
            bl = true;
        }
        for (ActivePopup activePopup : this.popups.values()) {
            if (!activePopup.update(layerListenerArray)) continue;
            bl = true;
        }
        if (bl && !this.updating) {
            this.updating = true;
            Bukkit.getScheduler().runTaskLater((Plugin)HappyHUD.getInstance(), () -> {
                this.updating = false;
                this.send();
            }, 1L);
        }
    }

    public void sendPopup(HudPopup hudPopup, int n, String ... stringArray) {
        ActivePopup activePopup;
        String string = hudPopup.getKey();
        if (this.popups.containsKey(string)) {
            activePopup = this.popups.get(string);
        } else {
            activePopup = new ActivePopup(this, hudPopup);
            this.popups.put(string, activePopup);
        }
        activePopup.add(n, stringArray);
    }

    public void removePopup(ActivePopup activePopup) {
        this.removePopup(((HudPopup)activePopup.getParent()).getKey());
    }

    public void removePopup(String string) {
        this.popups.remove(string);
    }

    public void send() {
        HappyHUD happyHUD = HappyHUD.getInstance();
        if (this.player.isOnline()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)happyHUD, () -> {
                TextComponent.Builder builder = Component.text();
                for (ActiveLayout abstractActiveElementHolder : this.layouts.values()) {
                    builder.append(abstractActiveElementHolder.getComponent());
                }
                for (ActivePopup activePopup : this.popups.values()) {
                    builder.append(activePopup.getComponent());
                }
                Iterator<AbstractActiveElementHolder> iterator = WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(builder.build())));
                Bukkit.getScheduler().runTask((Plugin)happyHUD, () -> this.barHandler.setHud((WrappedChatComponent)iterator));
            });
        }
    }

    public boolean addLayout(@NotNull HudLayout hudLayout) {
        if (!this.layouts.containsKey(hudLayout.getKey())) {
            this.layouts.put(hudLayout.getKey(), new ActiveLayout(this, hudLayout));
            PersistentDataContainer persistentDataContainer = (PersistentDataContainer)this.getPersistentDataContainer().get(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER);
            if (persistentDataContainer != null) {
                persistentDataContainer.set(new NamespacedKey((Plugin)HappyHUD.getInstance(), hudLayout.getKey()), HudTag.BOOLEAN, (Object)true);
                this.getPersistentDataContainer().set(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER, (Object)persistentDataContainer);
            }
            return true;
        }
        return false;
    }

    public boolean removeLayout(@NotNull HudLayout hudLayout) {
        if (this.layouts.containsKey(hudLayout.getKey())) {
            this.layouts.remove(hudLayout.getKey());
            PersistentDataContainer persistentDataContainer = (PersistentDataContainer)this.getPersistentDataContainer().get(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER);
            if (persistentDataContainer != null) {
                persistentDataContainer.set(new NamespacedKey((Plugin)HappyHUD.getInstance(), hudLayout.getKey()), HudTag.BOOLEAN, (Object)false);
                this.getPersistentDataContainer().set(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER, (Object)persistentDataContainer);
            }
            return true;
        }
        return false;
    }

    public void resetLayout(@NotNull HudLayout hudLayout) {
        this.layouts.remove(hudLayout.getKey());
        PersistentDataContainer persistentDataContainer = (PersistentDataContainer)this.getPersistentDataContainer().get(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER);
        if (persistentDataContainer != null) {
            persistentDataContainer.remove(new NamespacedKey((Plugin)HappyHUD.getInstance(), hudLayout.getKey()));
            this.getPersistentDataContainer().set(LAYOUTS_KEY, PersistentDataType.TAG_CONTAINER, (Object)persistentDataContainer);
        }
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.player.getPersistentDataContainer();
    }

    public static HudHolder get(Player player) {
        return DATA.get(player);
    }

    public static boolean has(Player player) {
        if (player == null) {
            return false;
        }
        return DATA.containsKey(player);
    }

    public static void create(Player player, boolean bl) {
        PersistentDataContainer persistentDataContainer;
        HappyHUD happyHUD = HappyHUD.getInstance();
        if (happyHUD.getGeyser() != null && happyHUD.getConfig().getBoolean("disable-geyser-players", true) && happyHUD.getGeyser().isBedrockPlayer(player.getUniqueId())) {
            return;
        }
        if (DATA.containsKey(player)) {
            DATA.get(player).remove();
        }
        if (bl) {
            player.getPersistentDataContainer().remove(ENABLE_KEY);
        }
        if (!(persistentDataContainer = player.getPersistentDataContainer()).has(ENABLE_KEY, HudTag.BOOLEAN) || ((Boolean)persistentDataContainer.get(ENABLE_KEY, HudTag.BOOLEAN)).booleanValue()) {
            HudHolder hudHolder = new HudHolder(player);
            DATA.put(player, hudHolder);
            hudHolder.initialize();
        }
    }

    public static Collection<HudHolder> holders() {
        return DATA.values();
    }

    public static class PlayerListener
    implements Listener {
        @EventHandler(priority=EventPriority.LOWEST)
        public void onLogin(PlayerLoginEvent playerLoginEvent) {
            HudHolder.create(playerLoginEvent.getPlayer(), false);
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent playerJoinEvent) {
            Player player = playerJoinEvent.getPlayer();
            if (DATA.containsKey(player)) {
                DATA.get(player).initialize();
            }
        }

        @EventHandler
        public void onLeave(PlayerQuitEvent playerQuitEvent) {
            Player player = playerQuitEvent.getPlayer();
            if (DATA.containsKey(player)) {
                DATA.get(player).remove();
            }
        }
    }
}

