/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.element.layout;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.util.HudAlignment;
import com.ehhthan.happyhud.api.resourcepack.asset.position.OffsetPosition;
import com.ehhthan.happyhud.api.resourcepack.asset.position.ScreenPosition;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public class HudElement {
    private final String key;
    private final HudAsset asset;
    private final HudAlignment alignment;
    private final ScreenPosition screenPosition;

    public HudElement(ConfigurationSection configurationSection) {
        this.key = configurationSection.getName().toLowerCase(Locale.ROOT);
        this.asset = HappyHUD.getInstance().assets().get(configurationSection.getString("asset", ""));
        Preconditions.checkNotNull((Object)this.asset, (Object)"Asset does not exist.");
        this.alignment = HudAlignment.valueOf(configurationSection.getString("align", "RIGHT").toUpperCase(Locale.ROOT));
        Preconditions.checkArgument((boolean)configurationSection.isConfigurationSection("position"), (Object)"Element position is not defined.");
        this.screenPosition = new ScreenPosition((float)configurationSection.getDouble("position.x", 50.0), (float)configurationSection.getDouble("position.y", 50.0), new OffsetPosition(configurationSection.getInt("offset.x", 0), configurationSection.getInt("offset.y", 0), 0));
    }

    public String getKey() {
        return this.key;
    }

    public HudAsset getAsset() {
        return this.asset;
    }

    public HudAlignment getAlignment() {
        return this.alignment;
    }

    public ScreenPosition getScreenPosition() {
        return this.screenPosition;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HudElement hudElement = (HudElement)object;
        return this.getKey().equals(hudElement.getKey()) && this.getAsset().equals(hudElement.getAsset()) && this.getAlignment() == hudElement.getAlignment() && this.getScreenPosition().equals(hudElement.getScreenPosition());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getKey(), this.getAsset(), this.getAlignment(), this.getScreenPosition()});
    }
}

