/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.element.popup;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.element.ElementHolder;
import com.ehhthan.happyhud.api.element.layout.HudElement;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;

public class HudPopup
implements ElementHolder {
    private final String key;
    private final boolean requireUnique;
    private final List<HudElement> elements = new LinkedList<HudElement>();

    public HudPopup(ConfigurationSection configurationSection) {
        this.key = configurationSection.getName().toLowerCase(Locale.ROOT);
        this.requireUnique = configurationSection.getBoolean("require-unique");
        Preconditions.checkArgument((boolean)configurationSection.isConfigurationSection("elements"), (Object)"No elements have been defined.");
        configurationSection = configurationSection.getConfigurationSection("elements");
        for (String string : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            if (configurationSection2 == null) continue;
            try {
                this.elements.add(new HudElement(configurationSection2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HappyHUD.getInstance().getLogger().log(Level.WARNING, String.format("Could not load element '%s' from popup '%s': %s", string, this.key, illegalArgumentException.getMessage()));
            }
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public boolean isRequireUnique() {
        return this.requireUnique;
    }

    @Override
    public List<HudElement> getElements() {
        return this.elements;
    }

    @Override
    public String getType() {
        return "popup";
    }
}

