/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.condition;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.condition.ConditionAction;
import com.ehhthan.happyhud.api.hud.condition.HudCondition;
import com.ehhthan.happyhud.api.util.ComponentUtil;
import com.ehhthan.libraries.kyori.adventure.text.format.TextColor;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class ConditionHolder {
    private final List<HudCondition> conditions;

    public ConditionHolder(HudAsset hudAsset, List<String> list) {
        LinkedList<HudCondition> linkedList = new LinkedList<HudCondition>();
        for (String string : list) {
            try {
                HudCondition hudCondition = HappyHUD.getInstance().conditions().getCondition(string, hudAsset);
                linkedList.add(hudCondition);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HappyHUD.getInstance().getLogger().log(Level.WARNING, String.format("Could not load condition '%s' from asset '%s': %s", string, hudAsset.getKey(), illegalArgumentException.getMessage()));
            }
        }
        this.conditions = Lists.reverse(linkedList);
    }

    public Set<String> getPossibleTexturePaths() {
        HashSet<String> hashSet = new HashSet<String>();
        for (HudCondition hudCondition : this.conditions) {
            if (hudCondition.getAction() != ConditionAction.TEXTURE) continue;
            hashSet.add(hudCondition.getVariable());
        }
        return hashSet;
    }

    public ConditionResult result(@NotNull HudHolder hudHolder) {
        return new ConditionResult(hudHolder);
    }

    public class ConditionResult {
        private final boolean isHidden;
        private final TextColor color;
        private final String texturePath;

        public ConditionResult(HudHolder hudHolder) {
            boolean bl = false;
            TextColor textColor = null;
            String string = null;
            for (HudCondition hudCondition : ConditionHolder.this.conditions) {
                switch (hudCondition.getAction()) {
                    case HIDE: {
                        if (bl || hudCondition.result(hudHolder)) break;
                        bl = true;
                        break;
                    }
                    case COLOR: {
                        if (!hudCondition.result(hudHolder)) break;
                        textColor = ComponentUtil.color(hudCondition.getVariable());
                        break;
                    }
                    case TEXTURE: {
                        if (!hudCondition.result(hudHolder)) break;
                        string = hudCondition.getVariable();
                    }
                }
            }
            this.isHidden = bl;
            this.color = textColor;
            this.texturePath = string;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public boolean hasColor() {
            return this.color != null;
        }

        public TextColor getColor() {
            return this.color;
        }

        public boolean hasTexturePath() {
            return this.texturePath != null;
        }

        public String getTexturePath() {
            return this.texturePath;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ConditionResult conditionResult = (ConditionResult)object;
            return this.isHidden == conditionResult.isHidden && Objects.equals(this.color, conditionResult.color);
        }

        public int hashCode() {
            return Objects.hash(this.isHidden, this.color);
        }
    }
}

