/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.condition.type;

import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.HudLineConfig;
import com.ehhthan.happyhud.api.hud.condition.AbstractHudCondition;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.potion.PotionEffectType;

public class EffectCondition
extends AbstractHudCondition {
    private final List<PotionEffectType> effects = new ArrayList<PotionEffectType>();

    public EffectCondition(HudLineConfig hudLineConfig) {
        super(hudLineConfig);
        String[] stringArray = hudLineConfig.getStringList("e", "effect", "effects");
        Preconditions.checkNotNull((Object)stringArray, (Object)"Effects do not exist.");
        for (String string : stringArray) {
            this.effects.add(PotionEffectType.getByName((String)string));
        }
    }

    @Override
    public boolean conditionResult(HudHolder hudHolder) {
        for (PotionEffectType potionEffectType : this.effects) {
            if (!hudHolder.player().hasPotionEffect(potionEffectType)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EffectCondition effectCondition = (EffectCondition)object;
        return this.effects.equals(effectCondition.effects);
    }

    public int hashCode() {
        return Objects.hash(this.effects);
    }
}

