/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.condition.type;

import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.HudLineConfig;
import com.ehhthan.happyhud.api.hud.condition.AbstractHudCondition;
import com.ehhthan.happyhud.api.hud.condition.ConditionOperation;
import com.ehhthan.happyhud.api.hud.layer.Functional;
import com.ehhthan.happyhud.api.hud.layer.HudLayer;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class ProgressCondition
extends AbstractHudCondition {
    private final double value;
    private final ConditionOperation operation;
    private final ConditionOperation.EvaluationType evaluationType;
    private final String layer;
    private final HudAsset asset;
    private LayerListener listener;

    public ProgressCondition(HudLineConfig hudLineConfig, HudAsset hudAsset) {
        super(hudLineConfig);
        this.asset = hudAsset;
        this.layer = hudLineConfig.getString("l", "lay", "layer");
        String string = hudLineConfig.getString("v", "val", "value");
        Preconditions.checkNotNull((Object)string, (Object)"Value does not exist.");
        if (string.endsWith("%")) {
            this.evaluationType = ConditionOperation.EvaluationType.PERCENT;
            try {
                this.value = Double.parseDouble(string.replace("%", ""));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Argument is not a number.");
            }
        } else {
            this.evaluationType = ConditionOperation.EvaluationType.NUMBER;
            this.value = hudLineConfig.getDouble("v", "val", "value");
        }
        this.operation = hudLineConfig.getOperation();
    }

    @Override
    public boolean conditionResult(HudHolder hudHolder) {
        if (this.listener == null) {
            HudLayer hudLayer = this.asset.getLayer(this.layer);
            if (hudLayer instanceof Functional) {
                Functional functional = (Functional)((Object)hudLayer);
                this.listener = functional.getListener();
            } else {
                throw new IllegalArgumentException("Cannot apply this condition on a non functional layer.");
            }
        }
        double d = this.listener.getValue(hudHolder);
        if (this.evaluationType == ConditionOperation.EvaluationType.PERCENT) {
            double d2 = this.listener.getMax(hudHolder);
            d = d2 != 0.0 ? d / d2 * 100.0 : 0.0;
        }
        return this.operation.evaluate(d, this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProgressCondition progressCondition = (ProgressCondition)object;
        return Double.compare(progressCondition.value, this.value) == 0 && this.listener.equals(progressCondition.listener) && this.operation == progressCondition.operation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.listener, this.value, this.operation});
    }
}

