/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.layer;

import java.util.Objects;

public class LayerScale {
    public static final LayerScale UNSCALED = new LayerScale(1.0, 1.0, false);
    private final double xScale;
    private final double yScale;
    private final boolean scaleOffset;

    public LayerScale(double d, double d2, boolean bl) {
        this.xScale = d;
        this.yScale = d2;
        this.scaleOffset = bl;
    }

    public LayerScale(double d, double d2) {
        this(d, d2, false);
    }

    public LayerScale(double d, boolean bl) {
        this(d, d, bl);
    }

    public LayerScale(double d) {
        this(d, d, false);
    }

    public double getX() {
        return this.xScale;
    }

    public double getY() {
        return this.yScale;
    }

    public boolean isScaleOffset() {
        return this.scaleOffset;
    }

    public int scaleX(int n) {
        return (int)((double)n * this.xScale);
    }

    public int scaleY(int n) {
        return (int)((double)n * this.yScale);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LayerScale layerScale = (LayerScale)object;
        return Double.compare(layerScale.xScale, this.xScale) == 0 && Double.compare(layerScale.yScale, this.yScale) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.xScale, this.yScale);
    }
}

