/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.layer.listener;

import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.happyhud.api.util.MathUtil;
import com.google.common.base.Function;
import java.util.Map;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ProvidedListener implements LayerListener
{
    DEBUG("debug"){

        @Override
        public double getValue(HudHolder hudHolder) {
            return 3.0;
        }

        @Override
        public double getMax(HudHolder hudHolder) {
            return 4.0;
        }
    }
    ,
    AIR("air"){

        @Override
        public double getValue(HudHolder hudHolder) {
            return Math.max(0, hudHolder.player().getRemainingAir());
        }

        @Override
        public double getMax(HudHolder hudHolder) {
            return hudHolder.player().getMaximumAir();
        }
    }
    ,
    ARMOR("armor"){

        @Override
        public double getValue(HudHolder hudHolder) {
            return Math.max(0.0, hudHolder.player().getAttribute(Attribute.GENERIC_ARMOR).getValue());
        }

        @Override
        public double getMax(HudHolder hudHolder) {
            return 20.0;
        }
    }
    ,
    EXP("exp"){

        @Override
        public double getValue(HudHolder hudHolder) {
            return Math.max(0.0f, hudHolder.player().getExp());
        }

        @Override
        public double getMax(HudHolder hudHolder) {
            Player player = hudHolder.player();
            return (player.getExp() + (float)player.getExpToLevel()) / (float)Math.max(1, player.getExpToLevel());
        }
    }
    ,
    FOOD("food"){

        @Override
        public double getValue(HudHolder hudHolder) {
            return Math.max(0, hudHolder.player().getFoodLevel());
        }

        @Override
        public double getMax(HudHolder hudHolder) {
            return 20.0;
        }
    }
    ,
    HEALTH("health"){

        @Override
        public double getValue(HudHolder hudHolder) {
            Player player = hudHolder.player();
            return Math.max(0.0, player.getHealth() + player.getAbsorptionAmount());
        }

        @Override
        public double getMax(HudHolder hudHolder) {
            return Math.max(0.0, hudHolder.player().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        }
    };

    private final String key;
    private final Map<String, Function<HudHolder, String>> placeholders;

    private ProvidedListener(String string2) {
        this.key = string2;
        this.placeholders = Map.of("value", hudHolder -> MathUtil.toFormatted(this.getValue((HudHolder)hudHolder)), "max", hudHolder -> MathUtil.toFormatted(this.getMax((HudHolder)hudHolder)), "percent", hudHolder -> MathUtil.toFormatted(this.getCoefficient((HudHolder)hudHolder)));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Map<String, Function<HudHolder, String>> getPlaceholders() {
        return this.placeholders;
    }
}

