/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.layer.type.texture;

import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.layer.AbstractHudLayer;
import com.ehhthan.happyhud.api.hud.layer.type.texture.TextureLayer;
import com.ehhthan.happyhud.api.resourcepack.texture.file.TextureFile;
import com.ehhthan.happyhud.api.util.ComponentUtil;
import com.ehhthan.libraries.kyori.adventure.text.format.TextColor;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTextureLayer
extends AbstractHudLayer
implements TextureLayer {
    private final TextColor color;
    private final String texturePath;

    protected AbstractTextureLayer(HudAsset hudAsset, ConfigurationSection configurationSection, int n) {
        super(hudAsset, configurationSection, n);
        Preconditions.checkArgument((boolean)configurationSection.isSet("texture.path"), (Object)"No texture has been defined.");
        this.color = configurationSection.isSet("color") ? ComponentUtil.color(configurationSection.getString("color", "white")) : null;
        this.texturePath = configurationSection.getString("texture.path", "");
    }

    @Override
    @Nullable
    public TextColor getColor() {
        return this.color;
    }

    @Override
    public String getTexturePath() {
        return this.texturePath;
    }

    @Override
    public TextureFile getTexture(String string) {
        Map<String, TextureFile> map = this.getTextures();
        if (string == null || !map.containsKey(this.getTexturePath())) {
            return map.get(this.getTexturePath());
        }
        return map.get(string);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractTextureLayer abstractTextureLayer = (AbstractTextureLayer)object;
        return Objects.equals(this.getColor(), abstractTextureLayer.getColor()) && this.getTexturePath().equals(abstractTextureLayer.getTexturePath()) && this.getScale().equals(abstractTextureLayer.getScale());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getColor(), this.getTexturePath(), this.getScale());
    }
}

