/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.asset.font;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.resourcepack.asset.font.CharacterSprite;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.PackProvider;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.TextComponent;
import com.ehhthan.libraries.kyori.adventure.text.format.Style;
import com.ehhthan.libraries.kyori.adventure.text.format.TextDecoration;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;

public class PackFont {
    private final String key;
    private final List<PackProvider> providers = new LinkedList<PackProvider>();
    private final Map<Integer, CharacterSprite> sprites = new HashMap<Integer, CharacterSprite>();

    public PackFont(ConfigurationSection configurationSection) {
        this.key = configurationSection.getName().toLowerCase(Locale.ROOT);
        Preconditions.checkArgument((boolean)configurationSection.isConfigurationSection("providers"), (Object)"There are no providers defined.");
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("providers");
        for (Object object : configurationSection2.getKeys(false)) {
            try {
                this.providers.add(PackProvider.get(configurationSection2.getConfigurationSection((String)object)));
            }
            catch (IOException | IllegalArgumentException exception) {
                HappyHUD.getInstance().getLogger().log(Level.WARNING, String.format("Could not load provider '%s' from font '%s': %s", object, this.key, exception.getMessage()));
            }
        }
        for (Object object : Lists.reverse(this.providers)) {
            this.sprites.putAll(object.getSprites());
        }
    }

    public String getKey() {
        return this.key;
    }

    public List<PackProvider> getProviders() {
        return this.providers;
    }

    public boolean has(int n) {
        if (n == 0) {
            return true;
        }
        return this.sprites.containsKey(n);
    }

    public CharacterSprite get(int n) {
        if (n == 0) {
            return CharacterSprite.NULL;
        }
        return this.sprites.get(n);
    }

    public int getWidth(Component component) {
        return this.getWidth(component, null) - 1;
    }

    private int getWidth(Component component, Style style) {
        style = style == null ? component.style() : component.style().merge(style, Style.Merge.Strategy.IF_ABSENT_ON_TARGET);
        int n = 0;
        String string = null;
        if (component instanceof TextComponent) {
            Iterator<Component> iterator = (TextComponent)component;
            string = iterator.content();
        }
        if (string != null && !string.isEmpty()) {
            for (Iterator<Component> iterator : (Iterator<Component>)string.codePoints().toArray()) {
                n = this.has((int)iterator) ? (n += this.get((int)iterator).getWidth()) : (n += CharacterSprite.NULL.getWidth());
                if (!Character.isWhitespace(iterator)) {
                    ++n;
                }
                if (!style.hasDecoration(TextDecoration.BOLD)) continue;
                ++n;
            }
        }
        if (!component.children().isEmpty()) {
            for (Component component2 : component.children()) {
                n += this.getWidth(component2, style);
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PackFont packFont = (PackFont)object;
        return this.key.equals(packFont.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

