/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.asset.position;

import com.ehhthan.happyhud.api.resourcepack.asset.position.PositionCase;
import com.ehhthan.happyhud.api.resourcepack.asset.position.ShaderInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class PositionContainer {
    private static final String CASE_FORMAT = "case %d:";
    private static final Function<Integer, Integer> ID_TO_ASCENT = n -> (n * 1000 + 500) * -1;
    private final List<PositionCase> positions = new LinkedList<PositionCase>();

    public PositionCase add(ShaderInfo shaderInfo) {
        PositionCase positionCase = new PositionCase(shaderInfo);
        if (!this.positions.contains(positionCase)) {
            this.positions.add(positionCase);
        }
        return positionCase;
    }

    private int getId(PositionCase positionCase) {
        return this.positions.indexOf(positionCase) + 100;
    }

    private int getAscent(PositionCase positionCase) {
        return ID_TO_ASCENT.apply(this.getId(positionCase));
    }

    public int addThenGetAscent(ShaderInfo shaderInfo) {
        return this.getAscent(this.add(shaderInfo));
    }

    public List<String> build() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (PositionCase positionCase : this.positions) {
            linkedList.add(PositionContainer.getTabs(3) + String.format(CASE_FORMAT, this.getId(positionCase)));
            linkedList.addAll(positionCase.getLines());
            linkedList.add(PositionContainer.getTabs(4) + "break;");
        }
        return linkedList;
    }

    protected static String getTabs(int n) {
        return "    ".repeat(Math.max(0, n));
    }
}

