/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.asset.position;

import com.ehhthan.happyhud.api.hud.layer.HudLayer;
import com.ehhthan.happyhud.api.hud.layer.LayerScale;
import com.ehhthan.happyhud.api.resourcepack.asset.position.ScreenPosition;

public class ShaderInfo {
    private final ScreenPosition position;
    private final boolean outlined;
    private final LayerScale scale;

    private ShaderInfo(Builder builder) {
        this.position = builder.position;
        this.outlined = builder.outlined;
        this.scale = builder.scale;
    }

    public ScreenPosition getPosition() {
        return this.position;
    }

    public boolean isOutlined() {
        return this.outlined;
    }

    public LayerScale getScale() {
        return this.scale;
    }

    public static Builder position(ScreenPosition screenPosition) {
        return new Builder(screenPosition);
    }

    public static class Builder {
        private final ScreenPosition position;
        private boolean outlined = false;
        private LayerScale scale = LayerScale.UNSCALED;

        private Builder(ScreenPosition screenPosition) {
            this.position = screenPosition;
        }

        public Builder layer(HudLayer hudLayer) {
            this.outlined = hudLayer.isOutlined();
            this.scale = hudLayer.getScale();
            return this;
        }

        public Builder outlined(boolean bl) {
            this.outlined = bl;
            return this;
        }

        public Builder scale(LayerScale layerScale) {
            this.scale = layerScale;
            return this;
        }

        public ShaderInfo build() {
            return new ShaderInfo(this);
        }
    }
}

