/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.component.key;

import com.ehhthan.happyhud.api.element.layout.HudElement;
import com.ehhthan.happyhud.api.resourcepack.component.key.AbstractLocaterKey;
import com.ehhthan.happyhud.api.resourcepack.texture.file.TextureFile;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TextureKey
extends AbstractLocaterKey<TextureFile> {
    private final int increment;

    protected TextureKey(HudElement hudElement, @NotNull TextureFile textureFile, int n) {
        super(hudElement, textureFile);
        this.increment = n;
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"Increment needs to be greater than or equal to 0.");
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextureKey textureKey = (TextureKey)object;
        return this.increment == textureKey.increment;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.increment);
    }
}

