/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.texture.file;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.hud.layer.type.texture.FunctionalTextureLayer;
import com.ehhthan.happyhud.api.resourcepack.texture.SizedImage;
import com.ehhthan.happyhud.api.resourcepack.texture.file.CroppedTexture;
import com.ehhthan.happyhud.api.resourcepack.texture.file.SplitTexture;
import com.ehhthan.happyhud.api.resourcepack.texture.file.TiledTexture;
import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public interface TextureFile {
    public String getPath();

    public BufferedImage getBaseImage();

    @NotNull
    private static BufferedImage getImageFromPath(@NotNull String path) {
        File file = new File(HappyHUD.getInstance().getDataFolder(), "textures/" + path);
        Preconditions.checkArgument((boolean)file.exists(), (String)"Texture file does not exist: %s", (Object)file.getPath());
        try {
            return ImageIO.read(file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Texture file cannot be read: " + file.getPath());
        }
    }

    @NotNull
    private static String normalizePath(@NotNull String path) {
        if (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        String extension = ".png";
        if (!((String)path).endsWith(".png")) {
            path = (String)path + ".png";
        }
        return path;
    }

    public static SplitTexture split(@NotNull String path, FunctionalTextureLayer.TextureData data) {
        path = TextureFile.normalizePath(path);
        BufferedImage image = TextureFile.trim(TextureFile.getImageFromPath(path)).getImage();
        int increment = data.getIncrement();
        SizedImage[] splits = new SizedImage[increment];
        for (int i = 1; i <= increment; ++i) {
            int tileWidth = image.getWidth();
            int tileHeight = image.getHeight();
            int x = 0;
            int y = 0;
            double multiplier = (double)i / (double)increment;
            switch (data.getOrientation()) {
                case HORIZONTAL: {
                    int value = (int)((double)image.getWidth() * multiplier);
                    if (data.isReversed()) {
                        x = image.getWidth() - value;
                    }
                    tileWidth = value;
                    break;
                }
                case VERTICAL: {
                    int value = (int)((double)image.getHeight() * multiplier);
                    if (!data.isReversed()) {
                        y = image.getHeight() - value;
                    }
                    tileHeight = value;
                }
            }
            splits[i - 1] = new SizedImage(image.getSubimage(x, y, tileWidth, tileHeight), 0, 0);
        }
        return new SplitTexture(path, image, splits, data);
    }

    public static TiledTexture tiled(@NotNull String path, int rows, int columns) {
        path = TextureFile.normalizePath(path);
        BufferedImage image = TextureFile.getImageFromPath(path);
        SizedImage[][] tiles = new SizedImage[rows][columns];
        int tileWidth = image.getWidth() / columns;
        int tileHeight = image.getHeight() / rows;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                tiles[i][j] = TextureFile.trim(image.getSubimage(tileWidth * j, tileHeight * i, tileWidth, tileHeight));
            }
        }
        return new TiledTexture(path, image, tiles);
    }

    public static CroppedTexture cropped(@NotNull String path) {
        path = TextureFile.normalizePath(path);
        BufferedImage image = TextureFile.getImageFromPath(path);
        return new CroppedTexture(path, image, TextureFile.trim(image));
    }

    public static SizedImage trim(BufferedImage image) {
        BufferedImage cropped;
        int x;
        int y;
        int y2;
        int x2;
        int xMin = -1;
        int xMax = -1;
        int yMin = -1;
        int yMax = -1;
        int w = image.getWidth();
        int h = image.getHeight();
        block2: for (x2 = 0; x2 < w; ++x2) {
            for (y2 = 0; y2 < h; ++y2) {
                if (!TextureFile.isNotTransparent(image, x2, y2)) continue;
                xMin = x2;
                break block2;
            }
        }
        x2 = w;
        block4: while (x2-- > 0) {
            for (y2 = 0; y2 < h; ++y2) {
                if (!TextureFile.isNotTransparent(image, x2, y2)) continue;
                xMax = x2;
                break block4;
            }
        }
        block6: for (y = 0; y < h; ++y) {
            for (x = xMin; x <= xMax; ++x) {
                if (!TextureFile.isNotTransparent(image, x, y)) continue;
                yMin = y;
                break block6;
            }
        }
        y = h;
        block8: while (y-- > 0) {
            for (x = xMin; x <= xMax; ++x) {
                if (!TextureFile.isNotTransparent(image, x, y)) continue;
                yMax = y;
                break block8;
            }
        }
        try {
            cropped = image.getSubimage(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
        }
        catch (RasterFormatException e) {
            return new SizedImage(image, 0, 0);
        }
        return new SizedImage(cropped, xMin, yMin);
    }

    private static boolean isNotTransparent(BufferedImage image, int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        return image.getRGB(x, y) >> 24 != 0;
    }
}

