/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.comp.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import java.util.Objects;
import org.bukkit.entity.Player;

public abstract class AbstractPacket {
    protected PacketContainer handle;

    protected AbstractPacket(PacketContainer packetContainer, PacketType packetType) {
        if (packetContainer == null) {
            throw new IllegalArgumentException("Packet handle cannot be NULL.");
        }
        if (!com.google.common.base.Objects.equal((Object)packetContainer.getType(), (Object)packetType)) {
            throw new IllegalArgumentException(packetContainer.getHandle() + " is not a packet of type " + packetType);
        }
        this.handle = packetContainer;
    }

    public AbstractPacket(PacketType packetType) {
        this.handle = new PacketContainer(packetType);
        this.handle.getModifier().writeDefaults();
    }

    public PacketContainer getHandle() {
        return this.handle;
    }

    public void sendPacket(Player player) {
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, this.getHandle());
    }

    public void broadcastPacket() {
        ProtocolLibrary.getProtocolManager().broadcastServerPacket(this.getHandle());
    }

    public void receivePacket(Player player) {
        ProtocolLibrary.getProtocolManager().receiveClientPacket(player, this.getHandle());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractPacket abstractPacket = (AbstractPacket)object;
        return Objects.equals(this.handle, abstractPacket.handle);
    }

    public int hashCode() {
        return this.handle != null ? this.handle.hashCode() : 0;
    }
}

