/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.file;

import com.ehhthan.happyhud.file.FileVersion;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;

public class DirectoryCopyFileVisitor {
    public static DirectoryCopyFileVisitor INSTANCE = new DirectoryCopyFileVisitor();

    private DirectoryCopyFileVisitor() {
    }

    public void copy(String string, final Path path) {
        URI uRI = this.getClass().getResource("").toURI();
        FileSystem fileSystem = FileSystems.newFileSystem(uRI, Collections.emptyMap());
        final Path path2 = fileSystem.getPath(string, new String[0]);
        Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) {
                Path path22 = path.resolve(path2.relativize(path3).toString());
                Files.createDirectories(path22, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) {
                Path path22 = path.resolve(path2.relativize(path3).toString());
                if (!Files.exists(path22, new LinkOption[0])) {
                    Files.copy(path3, path22, new CopyOption[0]);
                } else if (FileVersion.check(path22.toFile())) {
                    Files.copy(path3, path22, StandardCopyOption.REPLACE_EXISTING);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        fileSystem.close();
    }
}

