/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.manager;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.MiniMessage;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageManager {
    private boolean hasWarned = false;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Logger logger;
    private final Map<String, String> messages = new HashMap<String, String>();

    public LanguageManager(HappyHUD happyHUD) {
        this.logger = happyHUD.getLogger();
    }

    public void reload(HappyHUD happyHUD) {
        this.messages.clear();
        File[] fileArray = new File(happyHUD.getDataFolder(), "language").listFiles((file, string) -> string.endsWith(".yml"));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
                for (String string2 : yamlConfiguration.getKeys(false)) {
                    String string3 = "";
                    if (yamlConfiguration.isList(string2)) {
                        string3 = String.join((CharSequence)"\n", yamlConfiguration.getStringList(string2));
                    } else if (yamlConfiguration.isString(string2)) {
                        string3 = yamlConfiguration.getString(string2);
                    }
                    this.messages.put(string2, string3);
                }
            }
        }
    }

    @Nullable
    public Component getMessage(@NotNull String string, boolean bl) {
        return this.getMessage(string, bl, null);
    }

    @Nullable
    public Component getMessage(@NotNull String string, boolean bl, @Nullable TagResolver tagResolver) {
        Object object;
        String string2 = bl ? this.messages.get("prefix") : "";
        String string3 = this.messages.get(string);
        if (string3 != null && (string3.isEmpty() || string3.equals("[]"))) {
            return null;
        }
        if (string3 == null) {
            if (!this.hasWarned) {
                this.logger.log(Level.WARNING, "Message Missing: " + string);
                this.logger.log(Level.WARNING, "You should either add this field yourself to your language.yml or refresh it.");
                this.hasWarned = true;
            }
            object = "<red>?!?";
        } else {
            object = string2 + string3;
        }
        if (tagResolver != null) {
            return this.miniMessage.deserialize((String)object, tagResolver);
        }
        return this.miniMessage.deserialize(object);
    }
}

