/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.manager;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.happyhud.api.hud.layer.listener.PlaceholderListener;
import com.ehhthan.happyhud.api.hud.layer.listener.ProvidedListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class ListenerManager {
    private LayerListener[] placeholderListeners;
    private final Map<String, LayerListener> listeners = new HashMap<String, LayerListener>();

    public void reload(HappyHUD happyHUD) {
        this.listeners.clear();
        File[] fileArray = new File(happyHUD.getDataFolder(), "listeners").listFiles((file, string) -> string.endsWith(".yml"));
        if (fileArray != null) {
            for (File object : fileArray) {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)object);
                for (String string2 : yamlConfiguration.getKeys(false)) {
                    if (!yamlConfiguration.isConfigurationSection(string2)) continue;
                    PlaceholderListener placeholderListener = new PlaceholderListener(yamlConfiguration.getConfigurationSection(string2));
                    this.listeners.put(placeholderListener.getKey(), placeholderListener);
                }
            }
        }
        this.placeholderListeners = this.listeners.values().toArray(new LayerListener[0]);
        for (ProvidedListener providedListener : ProvidedListener.values()) {
            this.listeners.put(providedListener.getKey(), providedListener);
        }
    }

    public boolean has(String string) {
        return this.listeners.containsKey(string.toLowerCase(Locale.ROOT));
    }

    public LayerListener get(String string) {
        return this.listeners.get(string.toLowerCase(Locale.ROOT));
    }

    public Collection<LayerListener> getListeners() {
        return this.listeners.values();
    }

    public LayerListener[] getPlaceholderListeners() {
        return this.placeholderListeners;
    }
}

