/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.libraries.kyori.adventure.text.serializer.gson;

import com.ehhthan.libraries.kyori.adventure.key.Key;
import com.ehhthan.libraries.kyori.adventure.text.BlockNBTComponent;
import com.ehhthan.libraries.kyori.adventure.text.BuildableComponent;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.ComponentLike;
import com.ehhthan.libraries.kyori.adventure.text.EntityNBTComponent;
import com.ehhthan.libraries.kyori.adventure.text.KeybindComponent;
import com.ehhthan.libraries.kyori.adventure.text.NBTComponent;
import com.ehhthan.libraries.kyori.adventure.text.NBTComponentBuilder;
import com.ehhthan.libraries.kyori.adventure.text.ScoreComponent;
import com.ehhthan.libraries.kyori.adventure.text.SelectorComponent;
import com.ehhthan.libraries.kyori.adventure.text.StorageNBTComponent;
import com.ehhthan.libraries.kyori.adventure.text.TextComponent;
import com.ehhthan.libraries.kyori.adventure.text.TranslatableComponent;
import com.ehhthan.libraries.kyori.adventure.text.format.Style;
import com.ehhthan.libraries.kyori.adventure.text.serializer.gson.SerializerFactory;
import com.ehhthan.libraries.kyori.adventure.util.Buildable;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

final class ComponentSerializerImpl
extends TypeAdapter<Component> {
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_WITH = "with";
    static final String SCORE = "score";
    static final String SCORE_NAME = "name";
    static final String SCORE_OBJECTIVE = "objective";
    static final String SCORE_VALUE = "value";
    static final String SELECTOR = "selector";
    static final String KEYBIND = "keybind";
    static final String EXTRA = "extra";
    static final String NBT = "nbt";
    static final String NBT_INTERPRET = "interpret";
    static final String NBT_BLOCK = "block";
    static final String NBT_ENTITY = "entity";
    static final String NBT_STORAGE = "storage";
    static final String SEPARATOR = "separator";
    static final Type COMPONENT_LIST_TYPE = new TypeToken<List<Component>>(){}.getType();
    private final Gson gson;

    static TypeAdapter<Component> create(Gson gson) {
        return new ComponentSerializerImpl(gson).nullSafe();
    }

    private ComponentSerializerImpl(Gson gson) {
        this.gson = gson;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildableComponent<?, ?> read(JsonReader jsonReader) {
        Object object;
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.STRING || jsonToken == JsonToken.NUMBER || jsonToken == JsonToken.BOOLEAN) {
            return Component.text(ComponentSerializerImpl.readString(jsonReader));
        }
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            void var3_4;
            Object var3_3 = null;
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                Object object2 = this.read(jsonReader);
                if (var3_4 == null) {
                    Buildable.Builder builder = object2.toBuilder();
                    continue;
                }
                var3_4.append((Component)object2);
            }
            if (var3_4 == null) {
                throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
            }
            jsonReader.endArray();
            return var3_4.build();
        }
        if (jsonToken != JsonToken.BEGIN_OBJECT) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
        }
        JsonObject jsonObject = new JsonObject();
        List list = Collections.emptyList();
        String string = null;
        String string2 = null;
        List list2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        boolean bl = false;
        BlockNBTComponent.Pos pos = null;
        String string9 = null;
        Key key = null;
        Object object3 = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            object = jsonReader.nextName();
            if (((String)object).equals(TEXT)) {
                string = ComponentSerializerImpl.readString(jsonReader);
                continue;
            }
            if (((String)object).equals(TRANSLATE)) {
                string2 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(TRANSLATE_WITH)) {
                list2 = (List)this.gson.fromJson(jsonReader, COMPONENT_LIST_TYPE);
                continue;
            }
            if (((String)object).equals(SCORE)) {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String string10 = jsonReader.nextName();
                    if (string10.equals(SCORE_NAME)) {
                        string3 = jsonReader.nextString();
                        continue;
                    }
                    if (string10.equals(SCORE_OBJECTIVE)) {
                        string4 = jsonReader.nextString();
                        continue;
                    }
                    if (string10.equals(SCORE_VALUE)) {
                        string5 = jsonReader.nextString();
                        continue;
                    }
                    jsonReader.skipValue();
                }
                if (string3 == null || string4 == null) {
                    throw new JsonParseException("A score component requires a name and objective");
                }
                jsonReader.endObject();
                continue;
            }
            if (((String)object).equals(SELECTOR)) {
                string6 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(KEYBIND)) {
                string7 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(NBT)) {
                string8 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(NBT_INTERPRET)) {
                bl = jsonReader.nextBoolean();
                continue;
            }
            if (((String)object).equals(NBT_BLOCK)) {
                pos = (BlockNBTComponent.Pos)this.gson.fromJson(jsonReader, SerializerFactory.BLOCK_NBT_POS_TYPE);
                continue;
            }
            if (((String)object).equals(NBT_ENTITY)) {
                string9 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(NBT_STORAGE)) {
                key = (Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (((String)object).equals(EXTRA)) {
                list = (List)this.gson.fromJson(jsonReader, COMPONENT_LIST_TYPE);
                continue;
            }
            if (((String)object).equals(SEPARATOR)) {
                object3 = this.read(jsonReader);
                continue;
            }
            jsonObject.add((String)object, (JsonElement)this.gson.fromJson(jsonReader, JsonElement.class));
        }
        if (string != null) {
            object = Component.text().content(string);
        } else if (string2 != null) {
            object = list2 != null ? Component.translatable().key(string2).args(list2) : Component.translatable().key(string2);
        } else if (string3 != null && string4 != null) {
            object = string5 == null ? Component.score().name(string3).objective(string4) : Component.score().name(string3).objective(string4).value(string5);
        } else if (string6 != null) {
            object = Component.selector().pattern(string6).separator((ComponentLike)object3);
        } else if (string7 != null) {
            object = Component.keybind().keybind(string7);
        } else {
            if (string8 == null) throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
            if (pos != null) {
                object = ComponentSerializerImpl.nbt(Component.blockNBT(), string8, bl, object3).pos(pos);
            } else if (string9 != null) {
                object = ComponentSerializerImpl.nbt(Component.entityNBT(), string8, bl, object3).selector(string9);
            } else {
                if (key == null) throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
                object = ComponentSerializerImpl.nbt(Component.storageNBT(), string8, bl, object3).storage(key);
            }
        }
        object.style((Style)this.gson.fromJson((JsonElement)jsonObject, SerializerFactory.STYLE_TYPE)).append(list);
        jsonReader.endObject();
        return object.build();
    }

    private static String readString(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.STRING || jsonToken == JsonToken.NUMBER) {
            return jsonReader.nextString();
        }
        if (jsonToken == JsonToken.BOOLEAN) {
            return String.valueOf(jsonReader.nextBoolean());
        }
        throw new JsonParseException("Token of type " + jsonToken + " cannot be interpreted as a string");
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B b, String string, boolean bl, @Nullable Component component) {
        return b.nbtPath(string).interpret(bl).separator(component);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(JsonWriter jsonWriter, Component component) {
        Object object;
        jsonWriter.beginObject();
        if (component.hasStyling() && (object = this.gson.toJsonTree((Object)component.style(), SerializerFactory.STYLE_TYPE)).isJsonObject()) {
            for (Map.Entry entry : object.getAsJsonObject().entrySet()) {
                jsonWriter.name((String)entry.getKey());
                this.gson.toJson((JsonElement)entry.getValue(), jsonWriter);
            }
        }
        if (!component.children().isEmpty()) {
            jsonWriter.name(EXTRA);
            this.gson.toJson(component.children(), COMPONENT_LIST_TYPE, jsonWriter);
        }
        if (component instanceof TextComponent) {
            jsonWriter.name(TEXT);
            jsonWriter.value(((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            object = (TranslatableComponent)component;
            jsonWriter.name(TRANSLATE);
            jsonWriter.value(object.key());
            if (!object.args().isEmpty()) {
                jsonWriter.name(TRANSLATE_WITH);
                this.gson.toJson(object.args(), COMPONENT_LIST_TYPE, jsonWriter);
            }
        } else if (component instanceof ScoreComponent) {
            object = (ScoreComponent)component;
            jsonWriter.name(SCORE);
            jsonWriter.beginObject();
            jsonWriter.name(SCORE_NAME);
            jsonWriter.value(object.name());
            jsonWriter.name(SCORE_OBJECTIVE);
            jsonWriter.value(object.objective());
            if (object.value() != null) {
                jsonWriter.name(SCORE_VALUE);
                jsonWriter.value(object.value());
            }
            jsonWriter.endObject();
        } else if (component instanceof SelectorComponent) {
            object = (SelectorComponent)component;
            jsonWriter.name(SELECTOR);
            jsonWriter.value(object.pattern());
            this.serializeSeparator(jsonWriter, object.separator());
        } else if (component instanceof KeybindComponent) {
            jsonWriter.name(KEYBIND);
            jsonWriter.value(((KeybindComponent)component).keybind());
        } else {
            if (!(component instanceof NBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(component);
            object = (NBTComponent)component;
            jsonWriter.name(NBT);
            jsonWriter.value(object.nbtPath());
            jsonWriter.name(NBT_INTERPRET);
            jsonWriter.value(object.interpret());
            this.serializeSeparator(jsonWriter, object.separator());
            if (component instanceof BlockNBTComponent) {
                jsonWriter.name(NBT_BLOCK);
                this.gson.toJson((Object)((BlockNBTComponent)component).pos(), SerializerFactory.BLOCK_NBT_POS_TYPE, jsonWriter);
            } else if (component instanceof EntityNBTComponent) {
                jsonWriter.name(NBT_ENTITY);
                jsonWriter.value(((EntityNBTComponent)component).selector());
            } else {
                if (!(component instanceof StorageNBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(component);
                jsonWriter.name(NBT_STORAGE);
                this.gson.toJson((Object)((StorageNBTComponent)component).storage(), SerializerFactory.KEY_TYPE, jsonWriter);
            }
        }
        jsonWriter.endObject();
    }

    private void serializeSeparator(JsonWriter jsonWriter, @Nullable Component component) {
        if (component != null) {
            jsonWriter.name(SEPARATOR);
            this.write(jsonWriter, component);
        }
    }

    static JsonParseException notSureHowToDeserialize(Object object) {
        return new JsonParseException("Don't know how to turn " + object + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
    }
}

