/*
 * Decompiled with CFR 0.152.
 */
package BarAPI;

import Utils.Reflection;
import Zombies.Configuration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DefaultDragonBar {
    private Constructor<?> constructSpawnEntityLiving;
    private Constructor<?> constructEntityDestroy;
    private Constructor<?> constructEnderDragon;
    private Class<?> entityClass;
    private Method setLocation;
    private Method setCustomName;
    private Method setHealth;
    private Method setInvisible;
    private Method getWorldHandle;
    private Method getPlayerHandle;
    private Field playerConnection;
    private Method sendPacket;
    private final Map<Player, Object> playerDragons = new HashMap<Player, Object>();

    public DefaultDragonBar() {
        int n = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);
        if (n <= 8) {
            try {
                this.constructEntityDestroy = Reflection.getNMSClass("PacketPlayOutEntityDestroy").getConstructor(int[].class);
                this.constructSpawnEntityLiving = Reflection.getNMSClass("PacketPlayOutSpawnEntityLiving").getConstructor(Reflection.getNMSClass("EntityLiving"));
                this.constructEnderDragon = Reflection.getNMSClass("EntityEnderDragon").getConstructor(Reflection.getNMSClass("World"));
                this.entityClass = Reflection.getNMSClass("Entity");
                this.setLocation = Reflection.getNMSClass("EntityEnderDragon").getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
                this.setCustomName = Reflection.getNMSClass("EntityEnderDragon").getMethod("setCustomName", String.class);
                this.setHealth = Reflection.getNMSClass("EntityEnderDragon").getMethod("setHealth", Float.TYPE);
                this.setInvisible = Reflection.getNMSClass("EntityEnderDragon").getMethod("setInvisible", Boolean.TYPE);
                this.getWorldHandle = Reflection.getCraftClass("CraftWorld").getMethod("getHandle", new Class[0]);
                this.getPlayerHandle = Reflection.getCraftClass("entity.CraftPlayer").getMethod("getHandle", new Class[0]);
                this.playerConnection = Reflection.getNMSClass("EntityPlayer").getDeclaredField("playerConnection");
                this.sendPacket = Reflection.getNMSClass("PlayerConnection").getMethod("sendPacket", Reflection.getNMSClass("Packet"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Object getEnderDragon(Player player) {
        if (this.playerDragons.containsKey(player)) {
            return this.playerDragons.get(player);
        }
        Object object = this.getWorldHandle.invoke((Object)player.getWorld(), new Object[0]);
        Object obj = this.constructEnderDragon.newInstance(object);
        this.playerDragons.put(player, obj);
        return obj;
    }

    public void changeText(Player player, String string, float f) {
        float f2 = f * 200.0f;
        if (this.playerDragons.containsKey(player)) {
            try {
                Object object = this.getEnderDragon(player);
                this.setLocation.invoke(object, this.getPlayerLocation(player).getX(), this.getPlayerLocation(player).getY(), this.getPlayerLocation(player).getZ(), Float.valueOf(0.0f), Float.valueOf(0.0f));
                this.setCustomName.invoke(object, Configuration.translateTextCodes(string));
                this.setHealth.invoke(object, Float.valueOf(f2));
                this.setInvisible.invoke(object, true);
                Object obj = this.constructSpawnEntityLiving.newInstance(object);
                Object object2 = this.getPlayerHandle.invoke((Object)player, new Object[0]);
                Object object3 = this.playerConnection.get(object2);
                this.sendPacket.invoke(object3, obj);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setBossBar(Player player, String string, float f) {
        if (this.playerDragons.containsKey(player)) {
            this.changeText(player, string, f);
            return;
        }
        float f2 = f * 200.0f;
        try {
            Object object = this.getEnderDragon(player);
            this.setLocation.invoke(object, this.getPlayerLocation(player).getX(), this.getPlayerLocation(player).getY(), this.getPlayerLocation(player).getZ(), Float.valueOf(0.0f), Float.valueOf(0.0f));
            this.setCustomName.invoke(object, Configuration.translateTextCodes(string));
            this.setHealth.invoke(object, Float.valueOf(f2));
            this.setInvisible.invoke(object, true);
            Object obj = this.constructSpawnEntityLiving.newInstance(object);
            Object object2 = this.getPlayerHandle.invoke((Object)player, new Object[0]);
            Object object3 = this.playerConnection.get(object2);
            this.sendPacket.invoke(object3, obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeBossBar(Player player) {
        if (this.playerDragons.containsKey(player)) {
            try {
                Object object = this.getEnderDragon(player);
                Entity entity = (Entity)this.entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
                Object obj = this.constructEntityDestroy.newInstance(new Object[]{new int[]{entity.getEntityId()}});
                Object object2 = this.getPlayerHandle.invoke((Object)player, new Object[0]);
                Object object3 = this.playerConnection.get(object2);
                this.sendPacket.invoke(object3, obj);
                entity.remove();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.playerDragons.remove(player);
        }
    }

    private int getCardinalDirection(Player player) {
        double d = (player.getLocation().getYaw() - 180.0f) % 360.0f;
        if (d < 0.0) {
            d += 360.0;
        }
        if (0.0 <= d && d < 22.5) {
            return 1;
        }
        if (22.5 <= d && d < 67.5) {
            return 5;
        }
        if (67.5 <= d && d < 112.5) {
            return 2;
        }
        if (112.5 <= d && d < 157.5) {
            return 6;
        }
        if (157.5 <= d && d < 202.5) {
            return 3;
        }
        if (202.5 <= d && d < 247.5) {
            return 7;
        }
        if (247.5 <= d && d < 292.5) {
            return 4;
        }
        if (292.5 <= d && d < 337.5) {
            return 8;
        }
        if (337.5 <= d && d < 360.0) {
            return 1;
        }
        return 0;
    }

    private Location getPlayerLocation(Player player) {
        Location location = player.getLocation();
        location.add(player.getLocation().getDirection().setY(0).multiply(50));
        return location;
    }
}

