/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import Events.ArenaPlayerDeathEvent;
import Perks.PerkType;
import Powerups.PowerupType;
import TitleAPI.Title;
import Utils.EntityUtils;
import Utils.ItemStackUtils;
import Weapons.Weapon;
import Zombies.Configuration;
import Zombies.GameArena;
import Zombies.Main;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Wither;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EntityHandler
implements Listener {
    @EventHandler
    public void practiceDummyEntity(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getEntity() instanceof Zombie && entityDamageByEntityEvent.getEntity().hasMetadata("PracticeDummy")) {
            entityDamageByEntityEvent.setDamage(0.0);
        }
    }

    @EventHandler
    public void practiceDummyEntity(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity() instanceof Zombie && entityDamageEvent.getEntity().hasMetadata("PracticeDummy")) {
            entityDamageEvent.setDamage(0.0);
        }
    }

    @EventHandler
    public void launchWitherBullets(ProjectileLaunchEvent projectileLaunchEvent) {
        GameArena gameArena;
        Wither wither;
        if (projectileLaunchEvent.getEntity() != null && projectileLaunchEvent.getEntity().getShooter() != null && projectileLaunchEvent.getEntity().getShooter() instanceof Wither && (wither = (Wither)projectileLaunchEvent.getEntity().getShooter()).hasMetadata("Arena") && (gameArena = Main.getInstance().getConfiguration().getGameArena((Entity)wither)) != null) {
            projectileLaunchEvent.getEntity().setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)gameArena.getName()));
            projectileLaunchEvent.getEntity().setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)gameArena.getFileConfiguration().getDouble("Gold.KingWither")));
            projectileLaunchEvent.getEntity().setMetadata("KingWither", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("KingWitherName")));
            projectileLaunchEvent.getEntity().setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(gameArena.getFileConfiguration().getString("Name.KingWither"))));
        }
    }

    @EventHandler
    public void launchWitherBullets(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (entityChangeBlockEvent.getEntity() != null && entityChangeBlockEvent.getEntity().hasMetadata("Arena")) {
            entityChangeBlockEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void blazeFire(BlockIgniteEvent blockIgniteEvent) {
        if (blockIgniteEvent.getIgnitingEntity() != null) {
            Entity entity;
            Fireball fireball;
            ProjectileSource projectileSource;
            if (blockIgniteEvent.getIgnitingEntity() instanceof Fireball && (projectileSource = (fireball = (Fireball)blockIgniteEvent.getIgnitingEntity()).getShooter()) != null && projectileSource instanceof Entity && (entity = (Entity)projectileSource).hasMetadata("Zombies")) {
                blockIgniteEvent.setCancelled(true);
            }
            if (blockIgniteEvent.getIgnitingEntity() instanceof SmallFireball && (projectileSource = (fireball = (SmallFireball)blockIgniteEvent.getIgnitingEntity()).getShooter()) != null && projectileSource instanceof Entity && (entity = (Entity)projectileSource).hasMetadata("Zombies")) {
                blockIgniteEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void entityDeath(EntityDeathEvent entityDeathEvent) {
        if (entityDeathEvent.getEntity().hasMetadata("Zombies")) {
            if (entityDeathEvent.getEntity().getPassenger() != null) {
                entityDeathEvent.getEntity().getPassenger().remove();
            }
            entityDeathEvent.setDroppedExp(0);
            entityDeathEvent.getDrops().clear();
            if (entityDeathEvent.getEntity().getEquipment().getHelmet() != null && entityDeathEvent.getEntity().getEquipment().getHelmet().getType() == Material.TNT) {
                entityDeathEvent.getEntity().getWorld().createExplosion(entityDeathEvent.getEntity().getLocation().getX(), entityDeathEvent.getEntity().getLocation().getY(), entityDeathEvent.getEntity().getLocation().getZ(), 1.0f, false, false);
            }
            entityDeathEvent.getEntity().removeMetadata("Zombies", (Plugin)Main.getInstance());
            if (Main.getInstance().getConfiguration().getGameArena((Entity)entityDeathEvent.getEntity()) != null && !entityDeathEvent.getEntity().hasMetadata("OtherSpawnReason")) {
                int n = Main.getInstance().getConfiguration().getGameArena((Entity)entityDeathEvent.getEntity()).getZombiesLeft();
                Main.getInstance().getConfiguration().getGameArena((Entity)entityDeathEvent.getEntity()).setZombiesLeft(--n);
            }
        } else if (Main.getInstance().getConfiguration().getGameArena((Entity)entityDeathEvent.getEntity()) != null) {
            entityDeathEvent.setDroppedExp(0);
            entityDeathEvent.getDrops().clear();
        }
    }

    @EventHandler
    public void spectatorDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity() instanceof Player) {
            Player player = (Player)entityDamageEvent.getEntity();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null && gameArena.isDisplayedPlayer(player) && !gameArena.hasPlayer(player)) {
                entityDamageEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void lightningDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity() instanceof Player && entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
            Player player = (Player)entityDamageEvent.getEntity();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null && gameArena.hasPlayer(player)) {
                entityDamageEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void spectatorDamageOther(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getDamager() instanceof Player) {
            Player player = (Player)entityDamageByEntityEvent.getDamager();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null && gameArena.isDisplayedPlayer(player) && !gameArena.hasPlayer(player)) {
                entityDamageByEntityEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void zombieDamage(EntityDamageEvent entityDamageEvent) {
        if ((entityDamageEvent.getEntity().hasMetadata("Zombies") || entityDamageEvent.getEntity().hasMetadata("Unknown")) && (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FIRE)) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void playerSelfDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity() instanceof Player) {
            Player player = (Player)entityDamageEvent.getEntity();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null && gameArena.hasPlayer(player) && (gameArena.isRevivedPlayer(player) || gameArena.isDead(player) || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.VOID || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.DROWNING || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.LAVA)) {
                entityDamageEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void preventJockey(final CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.getSpawnReason() == CreatureSpawnEvent.SpawnReason.JOCKEY && creatureSpawnEvent.getEntityType() == EntityType.SKELETON) {
            new BukkitRunnable(){

                public void run() {
                    GameArena gameArena;
                    Entity entity = creatureSpawnEvent.getEntity().getVehicle();
                    if (entity != null && (gameArena = Main.getInstance().getConfiguration().getGameArena(entity)) != null) {
                        creatureSpawnEvent.getEntity().remove();
                    }
                }
            }.runTaskLater((Plugin)Main.getInstance(), 10L);
        }
    }

    @EventHandler
    public void entityTeleport(EntityTeleportEvent entityTeleportEvent) {
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(entityTeleportEvent.getEntity());
        if (gameArena != null && entityTeleportEvent.getEntity().hasMetadata("Arena")) {
            entityTeleportEvent.setCancelled(true);
        }
    }

    private boolean isCriticalHit(Player player) {
        return player.getFallDistance() > 0.0f && !player.isOnGround() && !player.isInsideVehicle() && !player.hasPotionEffect(PotionEffectType.BLINDNESS) && player.getLocation().getBlock().getType() != Material.LADDER && player.getLocation().getBlock().getType() != Material.VINE;
    }

    @EventHandler
    public void targetEntity(EntityTargetEvent entityTargetEvent) {
        if (entityTargetEvent.getTarget() instanceof Player) {
            GameArena gameArena;
            Player player = (Player)entityTargetEvent.getTarget();
            if (entityTargetEvent.getEntity().hasMetadata("Arena") && (gameArena = Main.getInstance().getConfiguration().getGameArena(entityTargetEvent.getEntity())) != null) {
                GameArena gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
                if (gameArena2 == null) {
                    entityTargetEvent.setCancelled(true);
                } else if (!gameArena2.getName().equals(gameArena.getName())) {
                    entityTargetEvent.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void targetLivingEntity(EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (entityTargetLivingEntityEvent.getTarget() instanceof Player) {
            GameArena gameArena;
            Player player = (Player)entityTargetLivingEntityEvent.getTarget();
            if (entityTargetLivingEntityEvent.getEntity().hasMetadata("Arena") && (gameArena = Main.getInstance().getConfiguration().getGameArena(entityTargetLivingEntityEvent.getEntity())) != null) {
                GameArena gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
                if (gameArena2 == null) {
                    entityTargetLivingEntityEvent.setCancelled(true);
                } else if (!gameArena2.getName().equals(gameArena.getName())) {
                    entityTargetLivingEntityEvent.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void playerDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        GameArena gameArena;
        GameArena gameArena2;
        Player player;
        boolean bl = false;
        if (entityDamageByEntityEvent.getEntity() instanceof Player && entityDamageByEntityEvent.getDamager() instanceof Player) {
            player = (Player)entityDamageByEntityEvent.getEntity();
            gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena2 != null) {
                entityDamageByEntityEvent.setCancelled(true);
            }
        }
        if (entityDamageByEntityEvent.getDamager().hasMetadata("Arena") && entityDamageByEntityEvent.getEntity() instanceof Player) {
            player = (Player)entityDamageByEntityEvent.getEntity();
            gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena2 == null) {
                entityDamageByEntityEvent.setCancelled(true);
                return;
            }
        }
        if (entityDamageByEntityEvent.getEntity().hasMetadata("Arena") && entityDamageByEntityEvent.getDamager() instanceof Player) {
            player = (Player)entityDamageByEntityEvent.getDamager();
            gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena2 == null) {
                entityDamageByEntityEvent.setCancelled(true);
                return;
            }
        }
        if (entityDamageByEntityEvent.getEntity().hasMetadata("Arena") && entityDamageByEntityEvent.getDamager() instanceof Player) {
            player = (Player)entityDamageByEntityEvent.getDamager();
            gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena2 != null && !(gameArena = Main.getInstance().getConfiguration().getGameArena(entityDamageByEntityEvent.getEntity())).getName().equals(gameArena2.getName())) {
                entityDamageByEntityEvent.setCancelled(true);
                return;
            }
        }
        if (entityDamageByEntityEvent.getDamager().hasMetadata("Arena") && entityDamageByEntityEvent.getEntity() instanceof Player) {
            player = (Player)entityDamageByEntityEvent.getEntity();
            gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena2 != null && !(gameArena = Main.getInstance().getConfiguration().getGameArena(entityDamageByEntityEvent.getDamager())).getName().equals(gameArena2.getName())) {
                entityDamageByEntityEvent.setCancelled(true);
                return;
            }
        }
        if (entityDamageByEntityEvent.getDamager() instanceof Player && entityDamageByEntityEvent.getEntity().hasMetadata("Unknown")) {
            player = (Player)entityDamageByEntityEvent.getDamager();
            gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena2 != null && gameArena2.hasPlayer(player) && entityDamageByEntityEvent.getEntity().getVehicle() != null) {
                gameArena = entityDamageByEntityEvent.getEntity().getVehicle();
                if (gameArena instanceof Creature) {
                    Creature creature = (Creature)gameArena;
                    creature.damage(entityDamageByEntityEvent.getDamage(), entityDamageByEntityEvent.getDamager());
                }
                if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                    entityDamageByEntityEvent.setCancelled(true);
                }
            }
        }
        if (entityDamageByEntityEvent.getDamager() instanceof Player && entityDamageByEntityEvent.getEntity().hasMetadata("Zombies") && entityDamageByEntityEvent.getEntity() instanceof Creature) {
            player = (Player)entityDamageByEntityEvent.getDamager();
            gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena2 != null && gameArena2.hasPlayer(player)) {
                String string;
                double d;
                double d2;
                String string2;
                if (gameArena2.isRevivedPlayer(player) || gameArena2.isDead(player)) {
                    entityDamageByEntityEvent.setCancelled(true);
                    return;
                }
                double d3 = ((MetadataValue)entityDamageByEntityEvent.getEntity().getMetadata("Zombies").get(0)).asDouble();
                if (this.isCriticalHit(player)) {
                    d3 += gameArena2.getFileConfiguration().getDouble("Gold.CriticalHit");
                }
                if ((string2 = ItemStackUtils.getNBTString(player.getItemInHand(), "ItemDamage")) != null) {
                    double d4 = Double.parseDouble(string2);
                    if (Main.getInstance().getPerkHandler().hasPerk(player, PerkType.QUICK_FIRE)) {
                        d4 *= 1.25;
                    }
                    if (Main.getInstance().getPowerupHandler().isActive(gameArena2, PowerupType.INSTA_KILL) && !entityDamageByEntityEvent.getEntity().hasMetadata("BossHealth")) {
                        entityDamageByEntityEvent.setDamage(500.0);
                    }
                    d2 = ((Creature)entityDamageByEntityEvent.getEntity()).getMaxHealth();
                    d = d3 / d2;
                    long l = Math.round(d * d4);
                    int n = (int)Math.max(Math.min(Integer.MAX_VALUE, l), Integer.MIN_VALUE);
                    String string3 = ItemStackUtils.getNBTString(player.getItemInHand(), "WeaponName");
                    if (string3 == null) {
                        n = (int)((float)n * player.getAttackCooldown());
                    }
                    gameArena2.addGold(player, Main.getInstance().getPowerupHandler().isActive(gameArena2, PowerupType.INSTA_KILL) ? gameArena2.getFileConfiguration().getInt("Gold.InstaKill") : n);
                } else {
                    String string4 = ItemStackUtils.getNBTString(player.getItemInHand(), "WeaponDamage");
                    if (string4 != null && (string = ItemStackUtils.getNBTString(player.getItemInHand(), "WeaponName")) != null && string.equals("ThePuncher")) {
                        entityDamageByEntityEvent.setCancelled(true);
                        entityDamageByEntityEvent.setDamage(0.0);
                        Weapon weapon = Weapon.getWeapon(player.getItemInHand());
                        if (!Main.getInstance().getWeaponHandler().isCooldown(player, weapon)) {
                            double d5 = Double.parseDouble(string4);
                            if (Main.getInstance().getPerkHandler().hasPerk(player, PerkType.QUICK_FIRE)) {
                                d5 *= 1.25;
                            }
                            if (weapon != null) {
                                int n = weapon.isUltimate() ? weapon.getUltimateAffectedEnemies() : weapon.getAffectedEnemies();
                                for (Entity entity : entityDamageByEntityEvent.getEntity().getWorld().getNearbyEntities(entityDamageByEntityEvent.getEntity().getLocation(), (double)n, (double)n, (double)n)) {
                                    if (!(entity instanceof Creature) || !entity.hasMetadata("ZombieName")) continue;
                                    Creature creature = (Creature)entity;
                                    double d6 = d5;
                                    if (Main.getInstance().getPowerupHandler().isActive(gameArena2, PowerupType.INSTA_KILL) && !entity.hasMetadata("BossHealth")) {
                                        d6 = 500.0;
                                    }
                                    creature.setVelocity(new Vector(0, 0, 0));
                                    creature.setVelocity(entity.getLocation().subtract(player.getLocation()).toVector().setY(0.8).multiply(0.45).normalize());
                                    double d7 = ((Creature)entity).getHealth() - d6;
                                    if (d7 <= 0.0) {
                                        creature.damage(500.0);
                                        gameArena2.addKills(player, 1);
                                        bl = true;
                                    } else {
                                        creature.damage(d6);
                                    }
                                    double d8 = ((Creature)entity).getMaxHealth();
                                    double d9 = d3 / d8;
                                    long l = Math.round(d9 * d5);
                                    int n2 = (int)Math.max(Math.min(Integer.MAX_VALUE, l), Integer.MIN_VALUE);
                                    gameArena2.addGold(player, Main.getInstance().getPowerupHandler().isActive(gameArena2, PowerupType.INSTA_KILL) ? gameArena2.getFileConfiguration().getInt("Gold.InstaKill") : n2);
                                }
                            }
                        } else {
                            return;
                        }
                    }
                }
                Creature creature = (Creature)entityDamageByEntityEvent.getEntity();
                if (creature.getEquipment().getItemInHand() != null && creature.getEquipment().getItemInHand().containsEnchantment(Enchantment.FIRE_ASPECT)) {
                    player.setFireTicks(50);
                }
                string = EntityUtils.changeTarget(entityDamageByEntityEvent.getEntity(), player);
                creature.setTarget((LivingEntity)string);
                if (creature.getPassenger() != null && creature.getPassenger() instanceof Creature) {
                    Creature creature2 = (Creature)creature.getPassenger();
                    creature2.setTarget(creature.getTarget());
                }
                if (creature.getHealth() - entityDamageByEntityEvent.getDamage() <= 0.0) {
                    Main.getInstance().getPowerupHandler().spawnPowerup(player, gameArena2, entityDamageByEntityEvent.getEntity().getLocation());
                    if (creature.getPassenger() != null) {
                        if (creature.getPassenger().getPassenger() != null) {
                            creature.getPassenger().getPassenger().remove();
                        }
                        creature.getPassenger().remove();
                    }
                    if (creature.isValid()) {
                        if (creature.hasMetadata("BossHealth")) {
                            d2 = ((MetadataValue)creature.getMetadata("BossHealth").get(0)).asDouble();
                            creature.damage(d2);
                        } else {
                            creature.damage(100.0);
                        }
                    }
                    if (creature.hasMetadata("Inferno")) {
                        gameArena2.sendMessage(Main.getInstance().getConfiguration().getMessage("BossKill").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)creature.getMetadata("Inferno").get(0)).asString()));
                    }
                    if (creature.hasMetadata("Bombie")) {
                        gameArena2.sendMessage(Main.getInstance().getConfiguration().getMessage("BossKill").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)creature.getMetadata("Bombie").get(0)).asString()));
                    }
                    if (creature.hasMetadata("TheBroodmother")) {
                        gameArena2.sendMessage(Main.getInstance().getConfiguration().getMessage("BossKill").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)creature.getMetadata("TheBroodmother").get(0)).asString()));
                    }
                    if (creature.hasMetadata("KingSlime")) {
                        gameArena2.sendMessage(Main.getInstance().getConfiguration().getMessage("BossKill").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)creature.getMetadata("KingSlime").get(0)).asString()));
                    }
                    if (creature.hasMetadata("KingWither")) {
                        gameArena2.sendMessage(Main.getInstance().getConfiguration().getMessage("BossKill").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)creature.getMetadata("KingWither").get(0)).asString()));
                    }
                    if (creature.hasMetadata("Herobrine")) {
                        gameArena2.sendMessage(Main.getInstance().getConfiguration().getMessage("BossKill").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)creature.getMetadata("Herobrine").get(0)).asString()));
                    }
                    if (creature.hasMetadata("SantaClaus")) {
                        gameArena2.sendMessage(Main.getInstance().getConfiguration().getMessage("BossKill").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)creature.getMetadata("SantaClaus").get(0)).asString()));
                    }
                    if (creature.hasMetadata("Pennywise")) {
                        gameArena2.sendMessage(Main.getInstance().getConfiguration().getMessage("BossKill").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)creature.getMetadata("Pennywise").get(0)).asString()));
                    }
                    if (!bl) {
                        gameArena2.addKills(player, 1);
                    }
                } else if (creature.getPassenger() != null) {
                    Entity entity = creature.getPassenger();
                    if (creature.getPassenger().getPassenger() != null) {
                        entity = creature.getPassenger().getPassenger();
                    }
                    String string5 = "\u00a77[";
                    d = creature.getHealth() - entityDamageByEntityEvent.getDamage();
                    double d10 = 2.5;
                    if (creature.hasMetadata("BossHealth")) {
                        double d11 = ((MetadataValue)creature.getMetadata("BossHealth").get(0)).asDouble();
                        d10 = d11 / 20.0;
                    }
                    long l = Math.round(Math.ceil(d) / d10);
                    long l2 = Math.round(creature.getMaxHealth() / d10);
                    long l3 = l2 - l;
                    int n = 0;
                    while ((long)n < l) {
                        string5 = string5 + "\u00a7c|";
                        ++n;
                    }
                    n = 0;
                    while ((long)n < l3) {
                        string5 = string5 + "\u00a77|";
                        ++n;
                    }
                    string5 = string5 + "\u00a77]";
                    entity.setCustomName(string5);
                }
            }
        }
    }

    @EventHandler
    public void playerDamager(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        GameArena gameArena;
        Player player;
        if (entityDamageByEntityEvent.getEntity() instanceof Player && entityDamageByEntityEvent.getDamager().hasMetadata("Zombies")) {
            player = (Player)entityDamageByEntityEvent.getEntity();
            gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null && gameArena.hasPlayer(player)) {
                if (gameArena.isRevivedPlayer(player) || gameArena.isDead(player)) {
                    entityDamageByEntityEvent.setCancelled(true);
                    return;
                }
                Entity entity = entityDamageByEntityEvent.getDamager();
                String string = ((MetadataValue)entity.getMetadata("ZombieName").get(0)).asString();
                String string2 = gameArena.getFileConfiguration().getString("Name.Mosquito");
                if (string != null && string2 != null && string.equals(Configuration.translateTextCodes(string2))) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 0));
                }
                if (player.getHealth() - entityDamageByEntityEvent.getDamage() <= 0.0) {
                    player.setHealth(20.0);
                    gameArena.reloadHolograms(player);
                    if (gameArena.getAlivePlayers().size() == 1) {
                        Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerDeathEvent(player, entityDamageByEntityEvent.getDamager(), gameArena));
                        gameArena.setDead(player);
                        gameArena.sendMessage(Main.getInstance().getConfiguration().getMessage("ReviveDead").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%name%", ((MetadataValue)entity.getMetadata("ZombieName").get(0)).asString()));
                        return;
                    }
                    if (!gameArena.isRevivedPlayer(player)) {
                        gameArena.addRevivePlayer(player, entity);
                        Title title = new Title();
                        title.setFadeIn(5);
                        title.setStay(20);
                        title.setFadeOut(5);
                        title.setTitle("");
                        title.setSubTitle(Main.getInstance().getConfiguration().getMessage("KnockedDownTitle").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()));
                        title.sendTimes(gameArena.getDisplayedPlayers());
                        title.sendTitle(gameArena.getDisplayedPlayers());
                        title.sendSubTitle(gameArena.getDisplayedPlayers());
                        gameArena.sendMessage(Main.getInstance().getConfiguration().getMessage("Revive").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%time%", String.valueOf(Main.getInstance().getConfig().getDouble("Revive.Time"))).replace("%name%", ((MetadataValue)entityDamageByEntityEvent.getDamager().getMetadata("ZombieName").get(0)).asString()));
                    }
                }
            }
        }
        if (entityDamageByEntityEvent.getDamager() instanceof Player) {
            player = (Player)entityDamageByEntityEvent.getDamager();
            gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null && (gameArena.isRevivedPlayer(player) || gameArena.isDead(player))) {
                entityDamageByEntityEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void burnEntity(EntityCombustEvent entityCombustEvent) {
        if (entityCombustEvent.getEntity().hasMetadata("Zombies") || entityCombustEvent.getEntity().hasMetadata("PracticeDummy")) {
            entityCombustEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void damageItem(PlayerItemDamageEvent playerItemDamageEvent) {
        Player player = playerItemDamageEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null && gameArena.hasPlayer(player)) {
            playerItemDamageEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void targetRevived(EntityTargetEvent entityTargetEvent) {
        if (entityTargetEvent.getEntity() instanceof Player) {
            Player player = (Player)entityTargetEvent.getEntity();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null && (gameArena.isRevivedPlayer(player) || gameArena.isDead(player))) {
                entityTargetEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void targetRevived(EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (entityTargetLivingEntityEvent.getTarget() instanceof Player) {
            Player player = (Player)entityTargetLivingEntityEvent.getTarget();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null && (gameArena.isRevivedPlayer(player) || gameArena.isDead(player))) {
                entityTargetLivingEntityEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void endermiteTeleport(EntityTeleportEvent entityTeleportEvent) {
        Entity entity = entityTeleportEvent.getEntity();
        if (entity.hasMetadata("Arena")) {
            entityTeleportEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void playerExplodeDeath(EntityExplodeEvent entityExplodeEvent) {
        Entity entity = entityExplodeEvent.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null) {
                entityExplodeEvent.setCancelled(true);
                player.setHealth(player.getMaxHealth());
                player.setLevel(0);
                player.setExp(0.0f);
                if (gameArena.isDisplayedPlayer(player)) {
                    gameArena.reloadHolograms(player);
                    if (!gameArena.isRevivedPlayer(player)) {
                        Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerDeathEvent(player, null, gameArena));
                        gameArena.setDead(player);
                        gameArena.sendMessage(Main.getInstance().getConfiguration().getMessage("ReviveDeadUnknown").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()));
                    }
                }
            }
        }
    }

    @EventHandler
    public void playerDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            playerDeathEvent.setDeathMessage(null);
            player.setHealth(player.getMaxHealth());
            playerDeathEvent.setKeepInventory(true);
            playerDeathEvent.setDroppedExp(0);
            playerDeathEvent.setNewExp(0);
            playerDeathEvent.setNewLevel(0);
            playerDeathEvent.setNewTotalExp(0);
            if (gameArena.isDisplayedPlayer(player)) {
                gameArena.reloadHolograms(player);
                if (!gameArena.isRevivedPlayer(player)) {
                    Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerDeathEvent(player, null, gameArena));
                    gameArena.setDead(player);
                    gameArena.sendMessage(Main.getInstance().getConfiguration().getMessage("ReviveDeadUnknown").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()));
                }
            }
        }
    }
}

