/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import Utils.ArrayUtils;
import Utils.ItemStackUtils;
import Zombies.GameArena;
import Zombies.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MenuHandler
implements Listener {
    private Map<String, String> modeInformation = new HashMap<String, String>();
    private Map<String, Inventory> mapInventories = new HashMap<String, Inventory>();
    private int[] glassBorderIds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 46, 47, 48, 50, 51, 52};
    private int versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);

    public MenuHandler() {
        this.reload();
        new BukkitRunnable(){
            ItemStack backItem = null;

            public void run() {
                if (this.backItem == null) {
                    this.backItem = ItemStackUtils.getItem(Material.ARROW, 1, 0, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.BackItemTitle"), Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.BackItemLores"));
                }
                MenuHandler.this.update(this.backItem);
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 20L);
    }

    public void reload() {
        this.mapInventories = new HashMap<String, Inventory>();
        for (int i = 1; i <= 2; ++i) {
            int n;
            if (i == 1) {
                for (n = 0; n <= 2; ++n) {
                    this.mapInventories.put("Normal-" + n, Bukkit.createInventory(null, (int)54, (String)Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Title")));
                }
            }
            if (i != 2) continue;
            for (n = 0; n <= 2; ++n) {
                this.mapInventories.put("Endless-" + n, Bukkit.createInventory(null, (int)54, (String)Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Title")));
            }
        }
    }

    public void update(ItemStack itemStack) {
        for (Inventory object2 : this.mapInventories.values()) {
            object2.clear();
            object2.setItem(49, itemStack);
            object2.setItem(45, ItemStackUtils.getItem(Material.ENCHANTED_BOOK, 1, 0, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.RandomJoinItemTitle"), Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.RandomJoinItemLores")));
            object2.setItem(53, ItemStackUtils.getItem(Material.ENDER_PEARL, 1, 0, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.RejoinItemTitle"), Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.RejoinItemLores")));
            for (int n : this.glassBorderIds) {
                object2.setItem(n, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_STAINED_GLASS_PANE : Material.getMaterial((String)"STAINED_GLASS_PANE"), 1, 7, " ", new String[0]));
            }
        }
        ArrayList arrayList = new ArrayList();
        for (GameArena gameArena : Main.getInstance().getConfiguration().getArenaList()) {
            if (gameArena.getPlayers().size() < gameArena.getMaxPlayers() || gameArena.hasStarted() || gameArena.hasStopped()) continue;
            arrayList.add(gameArena);
        }
        for (GameArena gameArena : Main.getInstance().getConfiguration().getArenaList()) {
            if (gameArena.getPlayers().size() >= gameArena.getMaxPlayers() || gameArena.hasStarted() || gameArena.hasStopped() || gameArena.getPlayers().isEmpty()) continue;
            arrayList.add(gameArena);
        }
        for (GameArena gameArena : Main.getInstance().getConfiguration().getArenaList()) {
            if (gameArena.getPlayers().size() >= gameArena.getMaxPlayers() || gameArena.hasStarted() || gameArena.hasStopped() || !gameArena.getPlayers().isEmpty()) continue;
            arrayList.add(gameArena);
        }
        for (GameArena gameArena : Main.getInstance().getConfiguration().getArenaList()) {
            if (!gameArena.hasStarted() || gameArena.hasStopped()) continue;
            arrayList.add(gameArena);
        }
        for (GameArena gameArena : Main.getInstance().getConfiguration().getArenaList()) {
            if (!gameArena.hasStopped()) continue;
            arrayList.add(gameArena);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n;
            GameArena gameArena = (GameArena)iterator.next();
            int n2 = gameArena.isEndlessMode() ? 1 : 0;
            int n3 = gameArena.getDifficulty();
            n = Main.getInstance().getConfiguration().getInteger("MenuInventory.MapInventory.DataId.EmptyArena");
            String string = Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Color.EmptyArena");
            if (gameArena.getPlayers().size() >= gameArena.getMaxPlayers() && !gameArena.hasStarted()) {
                n = Main.getInstance().getConfiguration().getInteger("MenuInventory.MapInventory.DataId.FullArena");
                string = Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Color.FullArena");
            }
            if (gameArena.getPlayers().size() < gameArena.getMaxPlayers() && !gameArena.hasStarted() && !gameArena.getPlayers().isEmpty()) {
                n = Main.getInstance().getConfiguration().getInteger("MenuInventory.MapInventory.DataId.FilledArena");
                string = Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Color.FilledArena");
            }
            if (gameArena.getPlayers().size() < gameArena.getMaxPlayers() && !gameArena.hasStarted() && gameArena.getPlayers().isEmpty()) {
                n = Main.getInstance().getConfiguration().getInteger("MenuInventory.MapInventory.DataId.EmptyArena");
                string = Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Color.EmptyArena");
            }
            if (gameArena.hasStarted()) {
                n = Main.getInstance().getConfiguration().getInteger("MenuInventory.MapInventory.DataId.StartedArena");
                string = Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Color.StartedArena");
            }
            if (gameArena.hasStopped()) {
                n = Main.getInstance().getConfiguration().getInteger("MenuInventory.MapInventory.DataId.StoppedArena");
                string = Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Color.StoppedArena");
            }
            List<String> list = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MapInventory.MapInformation");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string2 : list) {
                arrayList2.add(string2.replace("%players%", String.valueOf(gameArena.getPlayers().size())).replace("%maxPlayers%", String.valueOf(gameArena.getMaxPlayers())).replace("%state%", gameArena.getMotdState()).replace("%round%", String.valueOf(gameArena.getRound())).replace("%time%", gameArena.getInGameTime()).replace("%zombiesLeft%", String.valueOf(gameArena.getZombiesLeft())));
            }
            if (n2 != 0) {
                this.mapInventories.get("Endless-" + n3).addItem(new ItemStack[]{ItemStackUtils.getItem(Material.getMaterial((String)Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.ItemType")), 1, n, string + gameArena.getName(), arrayList2)});
                continue;
            }
            this.mapInventories.get("Normal-" + n3).addItem(new ItemStack[]{ItemStackUtils.getItem(Material.getMaterial((String)Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.ItemType")), 1, n, string + gameArena.getName(), arrayList2)});
        }
    }

    public Inventory open(Player player, boolean bl, boolean bl2) {
        List<String> list = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.NormalModeItemLores");
        int n = 0;
        int n2 = 0;
        for (GameArena object22 : Main.getInstance().getConfiguration().getArenaList()) {
            if (object22.isEndlessMode()) {
                ++n2;
                continue;
            }
            ++n;
        }
        ArrayList arrayList = new ArrayList();
        for (String string : list) {
            arrayList.add(string.replace("%maps%", String.valueOf(n)));
        }
        List<String> list2 = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.EndlessModeItemLores");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Object object : list2) {
            arrayList2.add(((String)object).replace("%maps%", String.valueOf(n2)));
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.Title"));
        inventory.setItem(49, ItemStackUtils.getItem(Material.BARRIER, 1, 0, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.CloseItemTitle"), Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.CloseItemLores")));
        if (!bl2) {
            inventory.setItem(20, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_MONSTER_EGG : Material.getMaterial((String)"MONSTER_EGG"), 1, 54, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.NormalModeItemTitle"), arrayList));
            inventory.setItem(24, ItemStackUtils.addItemFlags(ItemStackUtils.enchant(ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_MONSTER_EGG : Material.getMaterial((String)"MONSTER_EGG"), 1, 54, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.EndlessModeItemTitle"), arrayList2), Enchantment.DAMAGE_ALL, 1), ItemFlag.HIDE_ENCHANTS));
        }
        for (Object object : (Object)this.glassBorderIds) {
            inventory.setItem((int)object, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_STAINED_GLASS_PANE : Material.getMaterial((String)"STAINED_GLASS_PANE"), 1, 7, " ", new String[0]));
        }
        inventory.setItem(45, ItemStackUtils.getItem(Material.ENCHANTED_BOOK, 1, 0, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.RandomJoinItemTitle"), Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.RandomJoinItemLores")));
        inventory.setItem(53, ItemStackUtils.getItem(Material.ENDER_PEARL, 1, 0, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.RejoinItemTitle"), Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.RejoinItemLores")));
        player.openInventory(inventory);
        if (this.modeInformation.containsKey(player.getUniqueId().toString()) && bl) {
            this.modeInformation.remove(player.getUniqueId().toString());
        }
        return inventory;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void clickMenu(InventoryClickEvent inventoryClickEvent) {
        Object object;
        Iterator iterator;
        ArrayList<String> arrayList;
        Object object2;
        Object object3;
        int n;
        int n2;
        int n3;
        Object object5;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (inventoryClickEvent.getClickedInventory() == null) {
            return;
        }
        if (inventoryClickEvent.getInventory() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (!inventoryClickEvent.getCurrentItem().hasItemMeta()) {
            return;
        }
        if (inventoryClickEvent.getView().getTitle().equalsIgnoreCase(Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.Title"))) {
            inventoryClickEvent.setCancelled(true);
            if (inventoryClickEvent.getSlot() == 49 && inventoryClickEvent.getCurrentItem().getType() == Material.BARRIER) {
                player.closeInventory();
            }
            if (inventoryClickEvent.getSlot() == 49 && inventoryClickEvent.getCurrentItem().getType() == Material.ARROW) {
                player.closeInventory();
                this.open(player, true, false);
            }
            if (inventoryClickEvent.getSlot() == 45) {
                Object object4 = object5 = ThreadLocalRandom.current().nextBoolean() ? "Normal" : "Endless";
                if (this.modeInformation.containsKey(player.getUniqueId().toString())) {
                    object5 = this.modeInformation.get(player.getUniqueId().toString());
                }
                Bukkit.dispatchCommand((CommandSender)player, (String)("zombies randomJoin " + object5));
            }
            if (inventoryClickEvent.getSlot() == 53) {
                object5 = null;
                if (this.modeInformation.containsKey(player.getUniqueId().toString())) {
                    object5 = this.modeInformation.get(player.getUniqueId().toString());
                }
                ArrayList<GameArena> arrayList2 = new ArrayList<GameArena>();
                for (GameArena gameArena : Main.getInstance().getConfiguration().getArenaList()) {
                    if (object5 == null) {
                        if (!gameArena.isQuitPlayer(player)) continue;
                        arrayList2.add(gameArena);
                        continue;
                    }
                    if ((!((String)object5).equals("Normal") || gameArena.isEndlessMode()) && (!((String)object5).equals("Endless") || !gameArena.isEndlessMode()) || !gameArena.isQuitPlayer(player)) continue;
                    arrayList2.add(gameArena);
                }
                if (!arrayList2.isEmpty()) {
                    GameArena gameArena = (GameArena)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    Bukkit.dispatchCommand((CommandSender)player, (String)("zombies rejoin " + gameArena.getName()));
                }
            }
            if (inventoryClickEvent.getSlot() == 20 && this.modeInformation.containsKey(player.getUniqueId().toString())) {
                object5 = this.modeInformation.get(player.getUniqueId().toString());
                player.openInventory(this.mapInventories.get((String)object5 + "-0"));
            }
            if (inventoryClickEvent.getSlot() == 22 && this.modeInformation.containsKey(player.getUniqueId().toString())) {
                object5 = this.modeInformation.get(player.getUniqueId().toString());
                player.openInventory(this.mapInventories.get((String)object5 + "-1"));
            }
            if (inventoryClickEvent.getSlot() == 24 && this.modeInformation.containsKey(player.getUniqueId().toString())) {
                object5 = this.modeInformation.get(player.getUniqueId().toString());
                player.openInventory(this.mapInventories.get((String)object5 + "-2"));
            }
            if (inventoryClickEvent.getSlot() == 20 && !this.modeInformation.containsKey(player.getUniqueId().toString())) {
                this.modeInformation.put(player.getUniqueId().toString(), "Normal");
            }
            if (inventoryClickEvent.getSlot() == 24 && !this.modeInformation.containsKey(player.getUniqueId().toString())) {
                this.modeInformation.put(player.getUniqueId().toString(), "Endless");
            }
            if (inventoryClickEvent.getSlot() == 20 && this.modeInformation.containsKey(player.getUniqueId().toString()) || inventoryClickEvent.getSlot() == 24 && this.modeInformation.containsKey(player.getUniqueId().toString())) {
                object5 = this.modeInformation.get(player.getUniqueId().toString());
                inventoryClickEvent.getClickedInventory().clear(20);
                inventoryClickEvent.getClickedInventory().clear(24);
                inventoryClickEvent.getClickedInventory().clear(49);
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
                for (GameArena object72 : Main.getInstance().getConfiguration().getArenaList()) {
                    if (object72.isEndlessMode()) {
                        switch (object72.getDifficulty()) {
                            case 0: {
                                ++n3;
                                break;
                            }
                            case 1: {
                                ++n2;
                                break;
                            }
                            case 2: {
                                ++n;
                            }
                        }
                        continue;
                    }
                    switch (object72.getDifficulty()) {
                        case 0: {
                            ++n4;
                            break;
                        }
                        case 1: {
                            ++n5;
                            break;
                        }
                        case 2: {
                            ++n6;
                        }
                    }
                }
                List<String> list = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.NormalDifficultyItemLores");
                ArrayList<String> n9 = new ArrayList<String>();
                object3 = list.iterator();
                while (object3.hasNext()) {
                    String string = (String)object3.next();
                    n9.add(string.replace("%maps%", String.valueOf(((String)object5).equals("Normal") ? n4 : n3)));
                }
                object3 = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.HardDifficultyItemLores");
                ArrayList<String> arrayList2 = new ArrayList<String>();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    arrayList = (String)object2.next();
                    arrayList2.add(((String)((Object)arrayList)).replace("%maps%", String.valueOf(((String)object5).equals("Normal") ? n5 : n2)));
                }
                object2 = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.RIPDifficultyItemLores");
                arrayList = new ArrayList<String>();
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    arrayList.add(((String)object).replace("%maps%", String.valueOf(((String)object5).equals("Normal") ? n6 : n)));
                }
                inventoryClickEvent.getClickedInventory().setItem(20, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_MONSTER_EGG : Material.getMaterial((String)"MONSTER_EGG"), 1, 54, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.NormalDifficultyItemTitle"), n9));
                inventoryClickEvent.getClickedInventory().setItem(22, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_MONSTER_EGG : Material.getMaterial((String)"MONSTER_EGG"), 1, 59, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.HardDifficultyItemTitle"), arrayList2));
                inventoryClickEvent.getClickedInventory().setItem(24, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_MONSTER_EGG : Material.getMaterial((String)"MONSTER_EGG"), 1, 58, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.RIPDifficultyItemTitle"), arrayList));
                inventoryClickEvent.getClickedInventory().setItem(49, ItemStackUtils.getItem(Material.ARROW, 1, 0, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.BackItemTitle"), Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.BackItemLores")));
            }
        }
        if (inventoryClickEvent.getView().getTitle().equalsIgnoreCase(Main.getInstance().getConfiguration().getMessage("MenuInventory.MapInventory.Title"))) {
            inventoryClickEvent.setCancelled(true);
            if (inventoryClickEvent.getSlot() == 45) {
                object5 = new ArrayList();
                for (int i = 0; i < inventoryClickEvent.getClickedInventory().getSize(); ++i) {
                    ItemStack itemStack;
                    if (i == 45 || i == 49 || i == 53 || ArrayUtils.contains(this.glassBorderIds, i) || inventoryClickEvent.getClickedInventory().getItem(i) == null || inventoryClickEvent.getClickedInventory().getItem(i).getType() == Material.AIR || !(itemStack = inventoryClickEvent.getClickedInventory().getItem(i)).hasItemMeta() || !itemStack.getItemMeta().hasDisplayName()) continue;
                    String string = ChatColor.stripColor((String)itemStack.getItemMeta().getDisplayName());
                    GameArena gameArena = Main.getInstance().getConfiguration().getArenaByName(string);
                    if (gameArena == null || gameArena.hasStarted() || gameArena.hasStopped()) continue;
                    if (gameArena.getDisplayedPlayers().size() >= gameArena.getMaxPlayers()) {
                        if (!Main.getInstance().getConfiguration().getBoolean("PremiumKickEnabled").booleanValue() || !player.hasPermission("zombies.fulljoin")) continue;
                        object5.add(gameArena);
                        continue;
                    }
                    object5.add(gameArena);
                }
                if (!object5.isEmpty()) {
                    GameArena gameArena = (GameArena)object5.get(ThreadLocalRandom.current().nextInt(object5.size()));
                    Bukkit.dispatchCommand((CommandSender)player, (String)("zombies join " + gameArena.getName()));
                }
            }
            if (inventoryClickEvent.getSlot() == 53) {
                object5 = new ArrayList();
                for (int i = 0; i < inventoryClickEvent.getClickedInventory().getSize(); ++i) {
                    ItemStack itemStack;
                    if (i == 45 || i == 49 || i == 53 || ArrayUtils.contains(this.glassBorderIds, i) || inventoryClickEvent.getClickedInventory().getItem(i) == null || inventoryClickEvent.getClickedInventory().getItem(i).getType() == Material.AIR || !(itemStack = inventoryClickEvent.getClickedInventory().getItem(i)).hasItemMeta() || !itemStack.getItemMeta().hasDisplayName()) continue;
                    String string = ChatColor.stripColor((String)itemStack.getItemMeta().getDisplayName());
                    GameArena gameArena = Main.getInstance().getConfiguration().getArenaByName(string);
                    if (gameArena == null || !gameArena.isQuitPlayer(player)) continue;
                    object5.add(gameArena);
                }
                if (!object5.isEmpty()) {
                    GameArena gameArena = (GameArena)object5.get(ThreadLocalRandom.current().nextInt(object5.size()));
                    Bukkit.dispatchCommand((CommandSender)player, (String)("zombies rejoin " + gameArena.getName()));
                }
            }
            if (inventoryClickEvent.getSlot() == 49 && inventoryClickEvent.getCurrentItem().getType() == Material.ARROW) {
                void var11_31;
                player.closeInventory();
                String string = this.modeInformation.get(player.getUniqueId().toString());
                Inventory inventory = this.open(player, false, true);
                inventory.clear(20);
                inventory.clear(24);
                int n7 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
                int n8 = 0;
                boolean bl = false;
                for (GameArena gameArena : Main.getInstance().getConfiguration().getArenaList()) {
                    if (gameArena.isEndlessMode()) {
                        switch (gameArena.getDifficulty()) {
                            case 0: {
                                ++n;
                                break;
                            }
                            case 1: {
                                ++n8;
                                break;
                            }
                            case 2: {
                                ++var11_31;
                            }
                        }
                        continue;
                    }
                    switch (gameArena.getDifficulty()) {
                        case 0: {
                            ++n7;
                            break;
                        }
                        case 1: {
                            ++n3;
                            break;
                        }
                        case 2: {
                            ++n2;
                        }
                    }
                }
                object3 = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.NormalDifficultyItemLores");
                ArrayList<String> arrayList3 = new ArrayList<String>();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    arrayList = (String)object2.next();
                    arrayList3.add(((String)((Object)arrayList)).replace("%maps%", String.valueOf(string.equals("Normal") ? n7 : n)));
                }
                object2 = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.HardDifficultyItemLores");
                arrayList = new ArrayList();
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    arrayList.add(((String)object).replace("%maps%", String.valueOf(string.equals("Normal") ? n3 : n8)));
                }
                iterator = Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.RIPDifficultyItemLores");
                object = new ArrayList();
                Iterator iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    object.add(string2.replace("%maps%", String.valueOf(string.equals("Normal") ? n2 : var11_31)));
                }
                inventory.setItem(20, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_MONSTER_EGG : Material.getMaterial((String)"MONSTER_EGG"), 1, 54, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.NormalDifficultyItemTitle"), arrayList3));
                inventory.setItem(22, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_MONSTER_EGG : Material.getMaterial((String)"MONSTER_EGG"), 1, 59, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.HardDifficultyItemTitle"), arrayList));
                inventory.setItem(24, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_MONSTER_EGG : Material.getMaterial((String)"MONSTER_EGG"), 1, 58, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.RIPDifficultyItemTitle"), (List<String>)object));
                inventory.setItem(49, ItemStackUtils.getItem(Material.ARROW, 1, 0, Main.getInstance().getConfiguration().getMessage("MenuInventory.MainInventory.BackItemTitle"), Main.getInstance().getConfiguration().getMessageList("MenuInventory.MainInventory.BackItemLores")));
            }
            if (inventoryClickEvent.getCurrentItem().hasItemMeta() && inventoryClickEvent.getSlot() != 49 && inventoryClickEvent.getSlot() != 45 && inventoryClickEvent.getSlot() != 53 && !ArrayUtils.contains(this.glassBorderIds, inventoryClickEvent.getSlot())) {
                object5 = ChatColor.stripColor((String)inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName());
                player.closeInventory();
                Bukkit.dispatchCommand((CommandSender)player, (String)("zombies join " + (String)object5));
            }
        }
    }

    public String getMode(Player player) {
        if (this.modeInformation.containsKey(player.getUniqueId().toString())) {
            return this.modeInformation.get(player.getUniqueId().toString());
        }
        return null;
    }
}

