/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import Zombies.Configuration;
import Zombies.GameArena;
import Zombies.Main;
import java.io.File;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MultiArenaHandler
implements Listener {
    @EventHandler
    public void changeSign(SignChangeEvent signChangeEvent) {
        Player player = signChangeEvent.getPlayer();
        if (player.hasPermission("zombies.admin") && Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue() && signChangeEvent.getLine(0).equalsIgnoreCase("Zombies")) {
            GameArena gameArena = Main.getInstance().getConfiguration().getArenaByName(ChatColor.stripColor((String)signChangeEvent.getLine(1)));
            if (gameArena != null) {
                final String string = gameArena.getName();
                File file = new File(Main.getInstance().getDataFolder(), "Maps/" + string + ".yml");
                if (file.exists()) {
                    YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                    List list = yamlConfiguration.getStringList("Signs");
                    Block block = signChangeEvent.getBlock();
                    list.add(block.getWorld().getName() + ":" + block.getX() + ":" + block.getY() + ":" + block.getZ());
                    yamlConfiguration.set("Signs", (Object)list);
                    try {
                        yamlConfiguration.save(file);
                        yamlConfiguration.load(file);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    gameArena.updateFile(file);
                    new BukkitRunnable(){

                        public void run() {
                            GameArena gameArena = Main.getInstance().getConfiguration().getArenaByName(string);
                            MultiArenaHandler.update(gameArena.getSignLocations(), gameArena);
                        }
                    }.runTaskLater((Plugin)Main.getInstance(), 5L);
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + " \u00a7aArena Sign has been added.");
                } else {
                    signChangeEvent.getBlock().breakNaturally();
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + " \u00a7cArena could not be found.");
                }
            } else {
                signChangeEvent.getBlock().breakNaturally();
                player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + " \u00a7cArena could not be found.");
            }
        }
    }

    @EventHandler
    public void clickSign(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK && playerInteractEvent.getClickedBlock() != null && playerInteractEvent.getClickedBlock().getState() instanceof Sign) {
            Sign sign = (Sign)playerInteractEvent.getClickedBlock().getState();
            if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
                Player player = playerInteractEvent.getPlayer();
                GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
                if (gameArena == null) {
                    GameArena gameArena2 = null;
                    for (GameArena gameArena3 : Main.getInstance().getConfiguration().getArenaList()) {
                        if (!gameArena3.getSignLocations().contains(sign.getLocation())) continue;
                        gameArena2 = gameArena3;
                    }
                    if (gameArena2 != null) {
                        Bukkit.dispatchCommand((CommandSender)player, (String)("zombies join " + gameArena2.getName()));
                    }
                }
            }
        }
    }

    public static void update(List<Location> list, GameArena gameArena) {
        if (!Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        if (gameArena == null) {
            return;
        }
        for (Location location : list) {
            if (!(location.getBlock().getState() instanceof Sign)) continue;
            Sign sign = (Sign)location.getBlock().getState();
            sign.setLine(0, Configuration.translateTextCodes(Main.getInstance().getConfiguration().getMessage("MultiArena.SignLayout.Line1").replace("%name%", gameArena.getName()).replace("%players%", gameArena.getPlayers().size() + "").replace("%maxPlayers%", String.valueOf(gameArena.getMaxPlayers())).replace("%state%", gameArena.getState())));
            sign.setLine(1, Configuration.translateTextCodes(Main.getInstance().getConfiguration().getMessage("MultiArena.SignLayout.Line2").replace("%name%", gameArena.getName()).replace("%players%", gameArena.getPlayers().size() + "").replace("%maxPlayers%", String.valueOf(gameArena.getMaxPlayers())).replace("%state%", gameArena.getState())));
            sign.setLine(2, Configuration.translateTextCodes(Main.getInstance().getConfiguration().getMessage("MultiArena.SignLayout.Line3").replace("%name%", gameArena.getName()).replace("%players%", gameArena.getPlayers().size() + "").replace("%maxPlayers%", String.valueOf(gameArena.getMaxPlayers())).replace("%state%", gameArena.getState())));
            sign.setLine(3, Configuration.translateTextCodes(Main.getInstance().getConfiguration().getMessage("MultiArena.SignLayout.Line4").replace("%name%", gameArena.getName()).replace("%players%", gameArena.getPlayers().size() + "").replace("%maxPlayers%", String.valueOf(gameArena.getMaxPlayers())).replace("%state%", gameArena.getState())));
            sign.update(true);
        }
    }
}

